/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.governance.handler;

import io.github.resilience4j.circuitbreaker.CircuitBreaker;
import io.github.resilience4j.circuitbreaker.CircuitBreakerConfig;
import io.github.resilience4j.circuitbreaker.CircuitBreakerRegistry;
import io.github.resilience4j.micrometer.tagged.TaggedCircuitBreakerMetrics;
import io.micrometer.core.instrument.MeterRegistry;
import java.time.Duration;
import org.apache.commons.lang3.StringUtils;
import org.apache.servicecomb.governance.handler.AbstractGovernanceHandler;
import org.apache.servicecomb.governance.handler.CircuitBreakerHandler;
import org.apache.servicecomb.governance.marker.GovernanceRequest;
import org.apache.servicecomb.governance.policy.CircuitBreakerPolicy;
import org.apache.servicecomb.governance.properties.InstanceIsolationProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;

public class InstanceIsolationHandler
extends AbstractGovernanceHandler<CircuitBreaker, CircuitBreakerPolicy> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CircuitBreakerHandler.class);
    private static final String DEFAULT_SERVICE_NAME = "default";
    private final InstanceIsolationProperties instanceIsolationProperties;
    private final MeterRegistry meterRegistry;

    public InstanceIsolationHandler(InstanceIsolationProperties instanceIsolationProperties, ObjectProvider<MeterRegistry> meterRegistry) {
        this.instanceIsolationProperties = instanceIsolationProperties;
        this.meterRegistry = (MeterRegistry)meterRegistry.getIfAvailable();
    }

    @Override
    protected String createKey(GovernanceRequest governanceRequest, CircuitBreakerPolicy policy) {
        return "servicecomb.instanceIsolation." + governanceRequest.getServiceId() + "." + governanceRequest.getInstanceId();
    }

    @Override
    protected void onConfigurationChanged(String key) {
        if (key.startsWith("servicecomb.instanceIsolation")) {
            for (String processorKey : this.processors.keySet()) {
                if (!processorKey.startsWith(key)) continue;
                this.processors.remove(processorKey);
            }
        }
    }

    @Override
    public CircuitBreakerPolicy matchPolicy(GovernanceRequest governanceRequest) {
        if (StringUtils.isEmpty((CharSequence)governanceRequest.getServiceId()) || StringUtils.isEmpty((CharSequence)governanceRequest.getInstanceId())) {
            LOGGER.info("Isolation is not properly configured, service id or instance id is empty.");
            return null;
        }
        CircuitBreakerPolicy circuitBreakerPolicy = (CircuitBreakerPolicy)this.instanceIsolationProperties.getParsedEntity().get(governanceRequest.getServiceId());
        if (circuitBreakerPolicy == null) {
            return (CircuitBreakerPolicy)this.instanceIsolationProperties.getParsedEntity().get(DEFAULT_SERVICE_NAME);
        }
        return circuitBreakerPolicy;
    }

    @Override
    protected CircuitBreaker createProcessor(GovernanceRequest governanceRequest, CircuitBreakerPolicy policy) {
        return this.getCircuitBreaker(governanceRequest, policy);
    }

    private CircuitBreaker getCircuitBreaker(GovernanceRequest governanceRequest, CircuitBreakerPolicy policy) {
        LOGGER.info("applying new policy: {}", (Object)policy.toString());
        CircuitBreakerConfig circuitBreakerConfig = CircuitBreakerConfig.custom().failureRateThreshold(policy.getFailureRateThreshold()).slowCallRateThreshold(policy.getSlowCallRateThreshold()).waitDurationInOpenState(Duration.parse(policy.getWaitDurationInOpenState())).slowCallDurationThreshold(Duration.parse(policy.getSlowCallDurationThreshold())).permittedNumberOfCallsInHalfOpenState(policy.getPermittedNumberOfCallsInHalfOpenState()).minimumNumberOfCalls(policy.getMinimumNumberOfCalls()).slidingWindowType(policy.getSlidingWindowTypeEnum()).slidingWindowSize(Integer.parseInt(policy.getSlidingWindowSize())).build();
        CircuitBreakerRegistry circuitBreakerRegistry = CircuitBreakerRegistry.of((CircuitBreakerConfig)circuitBreakerConfig);
        if (this.meterRegistry != null) {
            TaggedCircuitBreakerMetrics.ofCircuitBreakerRegistry((CircuitBreakerRegistry)circuitBreakerRegistry).bindTo(this.meterRegistry);
        }
        return circuitBreakerRegistry.circuitBreaker(governanceRequest.getInstanceId(), circuitBreakerConfig);
    }
}

