/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.governance.handler;

import com.google.common.eventbus.Subscribe;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.servicecomb.governance.MatchersManager;
import org.apache.servicecomb.governance.event.GovernanceConfigurationChangedEvent;
import org.apache.servicecomb.governance.event.GovernanceEventManager;
import org.apache.servicecomb.governance.marker.GovernanceRequest;
import org.apache.servicecomb.governance.policy.AbstractPolicy;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractGovernanceHandler<PROCESSOR, POLICY extends AbstractPolicy> {
    protected final Map<String, PROCESSOR> processors = new ConcurrentHashMap<String, PROCESSOR>();
    private final Object lock = new Object();
    protected MatchersManager matchersManager;

    @Autowired
    public void setMatchersManager(MatchersManager matchersManager) {
        this.matchersManager = matchersManager;
    }

    protected AbstractGovernanceHandler() {
        GovernanceEventManager.register(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R> PROCESSOR getActuator(GovernanceRequest governanceRequest) {
        POLICY policy = this.matchPolicy(governanceRequest);
        if (policy == null) {
            return null;
        }
        String key = this.createKey(governanceRequest, policy);
        PROCESSOR processor = this.processors.get(key);
        if (processor == null) {
            Object object = this.lock;
            synchronized (object) {
                processor = this.processors.get(key);
                if (processor == null) {
                    processor = this.createProcessor(governanceRequest, policy);
                    this.processors.put(key, processor);
                }
            }
        }
        return processor;
    }

    protected abstract String createKey(GovernanceRequest var1, POLICY var2);

    protected abstract POLICY matchPolicy(GovernanceRequest var1);

    protected abstract PROCESSOR createProcessor(GovernanceRequest var1, POLICY var2);

    protected void onConfigurationChanged(String key) {
        this.processors.remove(key);
    }

    @Subscribe
    public void onDynamicConfigurationListener(GovernanceConfigurationChangedEvent event) {
        event.getChangedConfigurations().forEach(v -> this.onConfigurationChanged((String)v));
    }
}

