/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.serviceregistry.auth;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.eventbus.Subscribe;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.apache.servicecomb.foundation.auth.Cipher;
import org.apache.servicecomb.foundation.common.concurrent.ConcurrentHashMapEx;
import org.apache.servicecomb.service.center.client.ServiceCenterClient;
import org.apache.servicecomb.service.center.client.model.RbacTokenRequest;
import org.apache.servicecomb.service.center.client.model.RbacTokenResponse;
import org.apache.servicecomb.serviceregistry.event.NotPermittedEvent;
import org.apache.servicecomb.serviceregistry.event.ServiceCenterEventBus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TokenCacheManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(TokenCacheManager.class);
    public static final String INVALID_TOKEN = "";
    private static final TokenCacheManager INSTANCE = new TokenCacheManager();
    private final Map<String, TokenCache> tokenCacheMap = new ConcurrentHashMapEx();
    private Map<String, ServiceCenterClient> serviceCenterClients;

    public static TokenCacheManager getInstance() {
        return INSTANCE;
    }

    private TokenCacheManager() {
    }

    public void setServiceCenterClients(Map<String, ServiceCenterClient> serviceCenterClients) {
        this.serviceCenterClients = serviceCenterClients;
    }

    public void addTokenCache(String registryName, String accountName, String password, Cipher cipher) {
        Objects.requireNonNull(registryName, "registryName should not be null!");
        if (this.tokenCacheMap.containsKey(registryName)) {
            LOGGER.warn("duplicate token cache registration for serviceRegistry[{}]", (Object)registryName);
            return;
        }
        this.tokenCacheMap.put(registryName, new TokenCache(registryName, accountName, password, cipher));
    }

    public String getToken(String registryName) {
        return Optional.ofNullable(this.tokenCacheMap.get(registryName)).map(TokenCache::getToken).orElse(null);
    }

    public class TokenCache {
        private static final String UN_AUTHORIZED_CODE_HALF_OPEN = "401302";
        private static final long TOKEN_REFRESH_TIME_IN_SECONDS = 1200000L;
        private final String registryName;
        private final String accountName;
        private final String password;
        private ExecutorService executorService;
        private LoadingCache<String, String> cache;
        private final Cipher cipher;
        private int lastStatusCode;
        private String lastErrorCode;

        public TokenCache(String registryName, String accountName, String password, Cipher cipher) {
            this.registryName = registryName;
            this.accountName = accountName;
            this.password = password;
            this.cipher = cipher;
            if (this.enabled()) {
                this.executorService = Executors.newFixedThreadPool(1, t -> new Thread(t, "rbac-executor-" + this.registryName));
                this.cache = CacheBuilder.newBuilder().maximumSize(1L).refreshAfterWrite(this.refreshTime(), TimeUnit.MILLISECONDS).build((CacheLoader)new CacheLoader<String, String>(){

                    public String load(String key) throws Exception {
                        return TokenCache.this.createHeaders();
                    }

                    public ListenableFuture<String> reload(String key, String oldValue) throws Exception {
                        return Futures.submit(() -> TokenCache.this.createHeaders(), (Executor)TokenCache.this.executorService);
                    }
                });
                ServiceCenterEventBus.getEventBus().register((Object)this);
            }
        }

        @Subscribe
        public void onNotPermittedEvent(NotPermittedEvent event) {
            this.executorService.submit(() -> {
                if (this.lastStatusCode == Response.Status.UNAUTHORIZED.getStatusCode() && UN_AUTHORIZED_CODE_HALF_OPEN.equals(this.lastErrorCode)) {
                    this.cache.refresh((Object)this.registryName);
                }
            });
        }

        private String createHeaders() {
            LOGGER.info("start to create RBAC headers");
            ServiceCenterClient serviceCenterClient = (ServiceCenterClient)TokenCacheManager.this.serviceCenterClients.get(this.registryName);
            RbacTokenRequest request = new RbacTokenRequest();
            request.setName(this.accountName);
            request.setPassword(new String(this.cipher.decrypt(this.password.toCharArray())));
            RbacTokenResponse rbacTokenResponse = serviceCenterClient.queryToken(request);
            this.lastStatusCode = rbacTokenResponse.getStatusCode();
            this.lastErrorCode = rbacTokenResponse.getErrorCode();
            if (Response.Status.UNAUTHORIZED.getStatusCode() == rbacTokenResponse.getStatusCode() || Response.Status.FORBIDDEN.getStatusCode() == rbacTokenResponse.getStatusCode()) {
                LOGGER.warn("username or password may be wrong, stop trying to query tokens.");
                return TokenCacheManager.INVALID_TOKEN;
            }
            if (Response.Status.NOT_FOUND.getStatusCode() == rbacTokenResponse.getStatusCode()) {
                LOGGER.warn("service center do not support RBAC token, you should not config account info");
                return TokenCacheManager.INVALID_TOKEN;
            }
            LOGGER.info("refresh token successfully {}", (Object)rbacTokenResponse.getStatusCode());
            return rbacTokenResponse.getToken();
        }

        protected long refreshTime() {
            return 1200000L;
        }

        public String getToken() {
            if (!this.enabled()) {
                return null;
            }
            try {
                return (String)this.cache.get((Object)this.registryName);
            }
            catch (Exception e) {
                LOGGER.error("failed to create token", (Throwable)e);
                return null;
            }
        }

        private boolean enabled() {
            return !StringUtils.isEmpty((CharSequence)this.accountName) && !StringUtils.isEmpty((CharSequence)this.password);
        }
    }
}

