/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.config;

import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.TypeDescription;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.Constructor;
import org.yaml.snakeyaml.constructor.SafeConstructor;

public final class YAMLUtil {
    private static final Yaml SAFE_PARSER = new Yaml((BaseConstructor)new SafeConstructor());
    private static final Logger LOGGER = LoggerFactory.getLogger(YAMLUtil.class);

    private YAMLUtil() {
    }

    public static Map<String, Object> yaml2Properties(InputStream input) {
        LinkedHashMap<String, Object> configurations = new LinkedHashMap<String, Object>();
        SAFE_PARSER.loadAll(input).forEach(data -> {
            if (!(data instanceof Map) || !YAMLUtil.isValidMap((Map)data)) {
                throw new IllegalArgumentException("input cannot be convert to map");
            }
            configurations.putAll(YAMLUtil.retrieveItems("", (Map)data));
        });
        return configurations;
    }

    private static boolean isValidMap(Map<Object, Object> data) {
        for (Map.Entry<Object, Object> entry : data.entrySet()) {
            Object key = entry.getKey();
            Object value = entry.getValue();
            if (key instanceof String) {
                if (!(value instanceof Map)) continue;
                return YAMLUtil.isValidMap((Map)value);
            }
            return false;
        }
        return true;
    }

    public static Map<String, Object> yaml2Properties(String input) {
        LinkedHashMap<String, Object> configurations = new LinkedHashMap<String, Object>();
        SAFE_PARSER.loadAll(input).forEach(data -> {
            if (!(data instanceof Map) || !YAMLUtil.isValidMap((Map)data)) {
                throw new IllegalArgumentException("input cannot be convert to map");
            }
            configurations.putAll(YAMLUtil.retrieveItems("", (Map)data));
        });
        return configurations;
    }

    public static <T> T parserObject(String yamlContent, Class<T> clazz) {
        Yaml parser = new Yaml((BaseConstructor)new Constructor(new TypeDescription(clazz, clazz)));
        return (T)parser.loadAs(yamlContent, clazz);
    }

    public static Map<String, Object> retrieveItems(String prefix, Map<String, Object> propertieMap) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        if (!prefix.isEmpty()) {
            prefix = prefix + ".";
        }
        for (Map.Entry<String, Object> entry : propertieMap.entrySet()) {
            if (entry.getValue() instanceof Map) {
                result.putAll(YAMLUtil.retrieveItems(prefix + entry.getKey(), (Map)entry.getValue()));
                continue;
            }
            String key = prefix + entry.getKey();
            if (key.startsWith("cse.")) {
                String servicecombKey = "servicecomb." + key.substring(key.indexOf(".") + 1);
                result.put(servicecombKey, entry.getValue());
            }
            result.put(key, entry.getValue());
        }
        return result;
    }
}

