/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.common.accessLog.core.element.impl;

import io.vertx.ext.web.RoutingContext;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.servicecomb.common.accessLog.core.element.AccessLogItem;
import org.apache.servicecomb.core.Invocation;
import org.apache.servicecomb.core.event.InvocationFinishEvent;
import org.apache.servicecomb.core.event.ServerAccessLogEvent;

public class InvocationContextAccessItem
implements AccessLogItem<RoutingContext> {
    public static final String NOT_FOUND = "-";
    String varName;

    public InvocationContextAccessItem(String varName) {
        this.varName = varName;
    }

    @Override
    public void appendServerFormattedItem(ServerAccessLogEvent accessLogEvent, StringBuilder builder) {
        String invocationContextValue = this.getValueFromInvocationContext(accessLogEvent);
        if (StringUtils.isEmpty((CharSequence)invocationContextValue)) {
            builder.append(NOT_FOUND);
            return;
        }
        builder.append(invocationContextValue);
    }

    @Override
    public void appendClientFormattedItem(InvocationFinishEvent finishEvent, StringBuilder builder) {
        Invocation invocation = finishEvent.getInvocation();
        if (null == invocation || invocation.getContext() == null || StringUtils.isEmpty((CharSequence)((CharSequence)finishEvent.getInvocation().getContext().get(this.varName)))) {
            builder.append(NOT_FOUND);
            return;
        }
        builder.append((String)finishEvent.getInvocation().getContext().get(this.varName));
    }

    protected String getValueFromInvocationContext(ServerAccessLogEvent accessLogEvent) {
        Map data = accessLogEvent.getRoutingContext().data();
        if (null == data || null == data.get("servicecomb-rest-invocation-context")) {
            return null;
        }
        return ((Invocation)data.get("servicecomb-rest-invocation-context")).getContext(this.varName);
    }

    public String getVarName() {
        return this.varName;
    }
}

