/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.core;

import org.apache.servicecomb.config.priority.PriorityPropertyManager;
import org.apache.servicecomb.core.BootListener;
import org.apache.servicecomb.core.ConsumerProvider;
import org.apache.servicecomb.core.ProducerProvider;
import org.apache.servicecomb.core.SCBEngine;
import org.apache.servicecomb.core.filter.FilterChainsManager;
import org.apache.servicecomb.foundation.common.utils.BeanUtils;
import org.apache.servicecomb.foundation.vertx.client.http.HttpClients;
import org.apache.servicecomb.registry.DiscoveryManager;
import org.apache.servicecomb.registry.RegistrationManager;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextClosedEvent;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.context.support.AbstractApplicationContext;
import org.springframework.core.Ordered;

public class CseApplicationListener
implements ApplicationListener<ApplicationEvent>,
Ordered,
ApplicationContextAware {
    private Class<?> initEventClass = ContextRefreshedEvent.class;
    private ApplicationContext applicationContext;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        if (this.applicationContext == applicationContext) {
            return;
        }
        this.applicationContext = applicationContext;
        BeanUtils.setContext((ApplicationContext)applicationContext);
        HttpClients.load();
        RegistrationManager.INSTANCE.init();
        DiscoveryManager.INSTANCE.init();
    }

    public void setInitEventClass(Class<?> initEventClass) {
        this.initEventClass = initEventClass;
    }

    public int getOrder() {
        return -1000;
    }

    public void onApplicationEvent(ApplicationEvent event) {
        if (this.initEventClass.isInstance(event)) {
            if (this.applicationContext instanceof AbstractApplicationContext) {
                ((AbstractApplicationContext)this.applicationContext).registerShutdownHook();
            }
            SCBEngine scbEngine = SCBEngine.getInstance();
            scbEngine.setApplicationContext(this.applicationContext);
            scbEngine.setPriorityPropertyManager((PriorityPropertyManager)this.applicationContext.getBean(PriorityPropertyManager.class));
            scbEngine.setFilterChainsManager((FilterChainsManager)this.applicationContext.getBean(FilterChainsManager.class));
            scbEngine.getConsumerProviderManager().getConsumerProviderList().addAll(this.applicationContext.getBeansOfType(ConsumerProvider.class).values());
            scbEngine.getProducerProviderManager().getProducerProviderList().addAll(this.applicationContext.getBeansOfType(ProducerProvider.class).values());
            scbEngine.addBootListeners(this.applicationContext.getBeansOfType(BootListener.class).values());
            scbEngine.run();
        } else if (event instanceof ContextClosedEvent && SCBEngine.getInstance() != null) {
            SCBEngine.getInstance().destroy();
        }
    }
}

