/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.foundation.common.config;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.servicecomb.foundation.common.config.impl.PropertiesLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.util.ResourceUtils;

public class PaaSResourceUtils
extends ResourceUtils {
    public static final String PROPERTIES_SUFFIX = ".properties";
    private static ResourcePatternResolver resourcePatternResolver = new PathMatchingResourcePatternResolver();

    public static Resource[] getResources(String locationPattern) {
        try {
            return resourcePatternResolver.getResources(locationPattern);
        }
        catch (IOException e) {
            return new Resource[0];
        }
    }

    public static List<Resource> getResources(String ... locationPatterns) {
        ArrayList<Resource> ret = new ArrayList<Resource>();
        for (String locationPattern : locationPatterns) {
            Resource[] resArr = PaaSResourceUtils.getResources(locationPattern);
            ret.addAll(Arrays.asList(resArr));
        }
        return ret;
    }

    public static void sortResources(List<Resource> resList, final String suffix) {
        resList.sort(new Comparator<Resource>(){

            @Override
            public int compare(Resource o1, Resource o2) {
                try {
                    if (ResourceUtils.isJarURL((URL)o1.getURL()) && ResourceUtils.isFileURL((URL)o2.getURL())) {
                        return -1;
                    }
                    String name1 = o1.getFilename();
                    String name2 = o2.getFilename();
                    if (StringUtils.isEmpty((CharSequence)name1) || StringUtils.isEmpty((CharSequence)name2)) {
                        throw new IOException(String.format("Resource %s or %s is not a file", o1.getURI(), o2.getURI()));
                    }
                    name1 = name1.substring(0, name1.length() - suffix.length());
                    name2 = name2.substring(0, name2.length() - suffix.length());
                    return name1.compareTo(name2);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    public static void sortProperties(List<Resource> resList) {
        PaaSResourceUtils.sortResources(resList, PROPERTIES_SUFFIX);
    }

    public static List<Resource> getSortedResources(String locationPattern, String suffix) {
        if (StringUtils.isEmpty((CharSequence)locationPattern)) {
            throw new RuntimeException("Resource path must not be null or empty");
        }
        if (!locationPattern.endsWith(suffix)) {
            throw new RuntimeException("Resource path must ends with " + suffix);
        }
        String prefix = locationPattern.substring(0, locationPattern.length() - suffix.length());
        List<Resource> resList = PaaSResourceUtils.getResources(locationPattern, prefix + ".*" + suffix);
        PaaSResourceUtils.sortResources(resList, suffix);
        return resList;
    }

    public static List<Resource> getSortedPorperties(String locationPattern) {
        return PaaSResourceUtils.getSortedResources(locationPattern, PROPERTIES_SUFFIX);
    }

    public static Properties loadMergedProperties(String locationPattern) throws Exception {
        PropertiesLoader loader = new PropertiesLoader(Arrays.asList(locationPattern));
        return (Properties)loader.load();
    }
}

