/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.governance.policy;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.servicecomb.governance.policy.AbstractPolicy;
import org.springframework.util.CollectionUtils;

public class RetryPolicy
extends AbstractPolicy {
    public static final int DEFAULT_MAX_ATTEMPTS = 3;
    public static final Duration DEFAULT_WAIT_DURATION = Duration.ofMillis(10L);
    public static final String DEFAULT_RETRY_ON_RESPONSE_STATUS = "502";
    private static final Duration INITIAL_INTERVAL = Duration.ofMillis(1000L);
    private static final float MULTIPLIER = 2.0f;
    private static final double RANDOMIZATION_FACTOR = 0.5;
    private static final String DEFAULT_RETRY_STRATEGY = "FixedInterval";
    private int maxAttempts = 3;
    private String waitDuration = DEFAULT_WAIT_DURATION.toString();
    private List<String> retryOnResponseStatus = new ArrayList<String>();
    private String retryStrategy = "FixedInterval";
    private String initialInterval = INITIAL_INTERVAL.toString();
    private float multiplier = 2.0f;
    private double randomizationFactor = 0.5;

    public List<String> getRetryOnResponseStatus() {
        if (CollectionUtils.isEmpty(this.retryOnResponseStatus)) {
            this.retryOnResponseStatus.add(DEFAULT_RETRY_ON_RESPONSE_STATUS);
        }
        return this.retryOnResponseStatus;
    }

    public void setRetryOnResponseStatus(List<String> retryOnResponseStatus) {
        this.retryOnResponseStatus = retryOnResponseStatus;
    }

    public int getMaxAttempts() {
        return this.maxAttempts;
    }

    public void setMaxAttempts(int maxAttempts) {
        this.maxAttempts = maxAttempts;
    }

    public String getWaitDuration() {
        return Duration.parse(this.waitDuration).toMillis() < 10L ? DEFAULT_WAIT_DURATION.toString() : this.waitDuration;
    }

    public void setWaitDuration(String waitDuration) {
        this.waitDuration = this.stringOfDuration(waitDuration, DEFAULT_WAIT_DURATION);
    }

    public String getRetryStrategy() {
        if (StringUtils.isEmpty((CharSequence)this.retryStrategy)) {
            this.retryStrategy = DEFAULT_RETRY_STRATEGY;
        }
        return this.retryStrategy;
    }

    public void setRetryStrategy(String retryStrategy) {
        this.retryStrategy = retryStrategy;
    }

    public String getInitialInterval() {
        return this.initialInterval;
    }

    public void setInitialInterval(String initialInterval) {
        this.initialInterval = this.stringOfDuration(initialInterval, INITIAL_INTERVAL);
    }

    public float getMultiplier() {
        return this.multiplier;
    }

    public void setMultiplier(float multiplier) {
        this.multiplier = multiplier;
    }

    public double getRandomizationFactor() {
        return this.randomizationFactor;
    }

    public void setRandomizationFactor(double randomizationFactor) {
        this.randomizationFactor = randomizationFactor;
    }

    @Override
    public boolean isValid() {
        if (this.maxAttempts < 1) {
            return false;
        }
        if (Duration.parse(this.waitDuration).toMillis() < 0L) {
            return false;
        }
        if (Duration.parse(this.initialInterval).toMillis() < 10L) {
            return false;
        }
        return super.isValid();
    }

    public String toString() {
        return "RetryPolicy{maxAttempts=" + this.maxAttempts + ", waitDuration=" + this.waitDuration + ", retryOnResponseStatus='" + this.retryOnResponseStatus + '\'' + '}';
    }
}

