/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.loadbalance.filter;

import com.google.common.eventbus.EventBus;
import com.netflix.config.DynamicBooleanProperty;
import com.netflix.config.DynamicPropertyFactory;
import java.util.HashMap;
import java.util.Map;
import org.apache.servicecomb.core.Invocation;
import org.apache.servicecomb.foundation.common.event.AlarmEvent;
import org.apache.servicecomb.foundation.common.event.EventManager;
import org.apache.servicecomb.loadbalance.Configuration;
import org.apache.servicecomb.loadbalance.ServiceCombLoadBalancerStats;
import org.apache.servicecomb.loadbalance.ServiceCombServer;
import org.apache.servicecomb.loadbalance.ServiceCombServerStats;
import org.apache.servicecomb.loadbalance.event.IsolationServerEvent;
import org.apache.servicecomb.registry.api.registry.MicroserviceInstance;
import org.apache.servicecomb.registry.discovery.DiscoveryContext;
import org.apache.servicecomb.registry.discovery.DiscoveryFilter;
import org.apache.servicecomb.registry.discovery.DiscoveryTreeNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IsolationDiscoveryFilter
implements DiscoveryFilter {
    public static final String TRYING_INSTANCES_EXISTING = "scb-hasTryingInstances";
    private static final Logger LOGGER = LoggerFactory.getLogger(IsolationDiscoveryFilter.class);
    private static final String EMPTY_INSTANCE_PROTECTION = "servicecomb.loadbalance.filter.isolation.emptyInstanceProtectionEnabled";
    private final DynamicBooleanProperty emptyProtection = DynamicPropertyFactory.getInstance().getBooleanProperty("servicecomb.loadbalance.filter.isolation.emptyInstanceProtectionEnabled", false);
    public EventBus eventBus = EventManager.getEventBus();

    public int getOrder() {
        return 500;
    }

    public IsolationDiscoveryFilter() {
        this.emptyProtection.addCallback(() -> {
            boolean newValue = this.emptyProtection.get();
            LOGGER.info("{} changed from {} to {}", new Object[]{EMPTY_INSTANCE_PROTECTION, this.emptyProtection, newValue});
        });
    }

    public boolean enabled() {
        return DynamicPropertyFactory.getInstance().getBooleanProperty("servicecomb.loadbalance.filter.isolation.enabled", true).get();
    }

    public boolean isGroupingFilter() {
        return false;
    }

    public DiscoveryTreeNode discovery(DiscoveryContext context, DiscoveryTreeNode parent) {
        Map instances = (Map)parent.data();
        Invocation invocation = (Invocation)context.getInputParameters();
        if (!Configuration.INSTANCE.isIsolationFilterOpen(invocation.getMicroserviceName())) {
            return parent;
        }
        HashMap filteredServers = new HashMap();
        instances.entrySet().forEach(stringMicroserviceInstanceEntry -> {
            MicroserviceInstance instance = (MicroserviceInstance)stringMicroserviceInstanceEntry.getValue();
            if (this.allowVisit(invocation, instance)) {
                filteredServers.put(stringMicroserviceInstanceEntry.getKey(), instance);
            }
        });
        DiscoveryTreeNode child = parent.children().computeIfAbsent("filterred", etn -> new DiscoveryTreeNode());
        if ("instancesAll".equals(context.getContextParameter("_KEY_ZONE_AWARE_STEP")) && filteredServers.isEmpty() && this.emptyProtection.get()) {
            LOGGER.warn("All servers have been isolated, allow one of them based on load balance rule.");
            child.data((Object)instances);
        } else {
            child.data(filteredServers);
        }
        return child;
    }

    private Settings createSettings(Invocation invocation) {
        Settings settings = new Settings();
        settings.errorThresholdPercentage = Configuration.INSTANCE.getErrorThresholdPercentage(invocation.getMicroserviceName());
        settings.singleTestTime = Configuration.INSTANCE.getSingleTestTime(invocation.getMicroserviceName());
        settings.enableRequestThreshold = Configuration.INSTANCE.getEnableRequestThreshold(invocation.getMicroserviceName());
        settings.continuousFailureThreshold = Configuration.INSTANCE.getContinuousFailureThreshold(invocation.getMicroserviceName());
        settings.minIsolationTime = Configuration.INSTANCE.getMinIsolationTime(invocation.getMicroserviceName());
        return settings;
    }

    private boolean allowVisit(Invocation invocation, MicroserviceInstance instance) {
        ServiceCombServer server = ServiceCombLoadBalancerStats.INSTANCE.getServiceCombServer(instance);
        if (server == null) {
            return true;
        }
        ServiceCombServerStats serverStats = ServiceCombLoadBalancerStats.INSTANCE.getServiceCombServerStats(server);
        Settings settings = this.createSettings(invocation);
        if (!this.checkThresholdAllowed(settings, serverStats)) {
            if (serverStats.isIsolated() && System.currentTimeMillis() - serverStats.getLastVisitTime() > settings.singleTestTime) {
                return ServiceCombServerStats.applyForTryingChance(invocation);
            }
            if (!serverStats.isIsolated()) {
                serverStats.markIsolated(true);
                this.eventBus.post((Object)new IsolationServerEvent(invocation, instance, serverStats, settings, AlarmEvent.Type.OPEN, server.getEndpoint()));
                LOGGER.warn("Isolate service {}'s instance {}.", (Object)invocation.getMicroserviceName(), (Object)instance.getInstanceId());
            }
            return false;
        }
        if (serverStats.isIsolated()) {
            if (System.currentTimeMillis() - serverStats.getIsolatedTime() <= (long)settings.minIsolationTime) {
                return false;
            }
            serverStats.markIsolated(false);
            this.eventBus.post((Object)new IsolationServerEvent(invocation, instance, serverStats, settings, AlarmEvent.Type.CLOSE, server.getEndpoint()));
            LOGGER.warn("Recover service {}'s instance {} from isolation.", (Object)invocation.getMicroserviceName(), (Object)instance.getInstanceId());
        }
        return true;
    }

    private boolean checkThresholdAllowed(Settings settings, ServiceCombServerStats serverStats) {
        if (serverStats.getTotalRequests() < settings.enableRequestThreshold) {
            return true;
        }
        if (settings.continuousFailureThreshold > 0 && serverStats.getContinuousFailureCount() >= (long)settings.continuousFailureThreshold) {
            return false;
        }
        if (settings.errorThresholdPercentage == 0) {
            return true;
        }
        return serverStats.getFailedRate() < settings.errorThresholdPercentage;
    }

    public class Settings {
        public int errorThresholdPercentage;
        public long singleTestTime;
        public long enableRequestThreshold;
        public int continuousFailureThreshold;
        public int minIsolationTime;
    }
}

