/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.registry.swagger;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Charsets;
import com.google.common.hash.Hashing;
import io.swagger.models.Swagger;
import java.net.URI;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.io.FilenameUtils;
import org.apache.servicecomb.foundation.common.concurrent.ConcurrentHashMapEx;
import org.apache.servicecomb.foundation.common.utils.JvmUtils;
import org.apache.servicecomb.foundation.common.utils.ResourceUtil;
import org.apache.servicecomb.registry.DiscoveryManager;
import org.apache.servicecomb.registry.RegistrationManager;
import org.apache.servicecomb.registry.api.registry.Microservice;
import org.apache.servicecomb.registry.api.registry.MicroserviceInstance;
import org.apache.servicecomb.registry.definition.MicroserviceNameParser;
import org.apache.servicecomb.swagger.SwaggerUtils;
import org.apache.servicecomb.swagger.generator.SwaggerGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SwaggerLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(SwaggerLoader.class);
    private Map<String, Map<String, Map<String, Swagger>>> apps = new ConcurrentHashMapEx();

    public static String calcSchemaSummary(String schemaContent) {
        return Hashing.sha256().newHasher().putString((CharSequence)schemaContent, Charsets.UTF_8).hash().toString();
    }

    public void registerSwaggersInLocation(String swaggersLocation) {
        String microserviceName = RegistrationManager.INSTANCE.getMicroservice().getServiceName();
        this.registerSwaggersInLocation(microserviceName, swaggersLocation);
    }

    public void registerSwaggersInLocation(String microserviceName, String swaggersLocation) {
        LOGGER.info("register schemas in location [{}], microserviceName=[{}]", (Object)swaggersLocation, (Object)microserviceName);
        try {
            List resourceUris = ResourceUtil.findResourcesBySuffix((String)swaggersLocation, (String)".yaml");
            if (resourceUris.isEmpty()) {
                LOGGER.error("register swagger in not exist location: \"{}\".", (Object)swaggersLocation);
                return;
            }
            for (URI uri : resourceUris) {
                URL url = uri.toURL();
                Swagger swagger = SwaggerUtils.parseAndValidateSwagger((URL)url);
                String schemaId = FilenameUtils.getBaseName((String)url.getPath());
                this.registerSwagger(microserviceName, schemaId, swagger);
            }
        }
        catch (Throwable e) {
            throw new IllegalStateException(String.format("failed to register swaggers, microserviceName=%s, location=%s.", microserviceName, swaggersLocation), e);
        }
    }

    public void registerSwagger(String microserviceName, String schemaId, Swagger swagger) {
        MicroserviceNameParser parser = new MicroserviceNameParser(RegistrationManager.INSTANCE.getMicroservice().getAppId(), microserviceName);
        this.registerSwagger(parser.getAppId(), parser.getShortName(), schemaId, swagger);
    }

    public Swagger registerSwagger(String appId, String shortName, String schemaId, Class<?> cls) {
        Swagger swagger = SwaggerGenerator.generate(cls);
        this.registerSwagger(appId, shortName, schemaId, swagger);
        return swagger;
    }

    public void registerSwagger(String appId, String shortName, String schemaId, Swagger swagger) {
        this.apps.computeIfAbsent(appId, k -> new ConcurrentHashMapEx()).computeIfAbsent(shortName, k -> new ConcurrentHashMapEx()).put(schemaId, swagger);
        LOGGER.info("register swagger appId={}, name={}, schemaId={}.", new Object[]{appId, shortName, schemaId});
    }

    public void unregisterSwagger(String appId, String shortName, String schemaId) {
        this.apps.getOrDefault(appId, Collections.emptyMap()).getOrDefault(shortName, Collections.emptyMap()).remove(schemaId);
    }

    public Swagger loadSwagger(Microservice microservice, Collection<MicroserviceInstance> instances, String schemaId) {
        Swagger swagger = this.loadLocalSwagger(microservice.getAppId(), microservice.getServiceName(), schemaId);
        if (swagger != null) {
            return swagger;
        }
        return this.loadFromRemote(microservice, instances, schemaId);
    }

    public Swagger loadLocalSwagger(String appId, String shortName, String schemaId) {
        LOGGER.info("try to load schema locally, appId=[{}], serviceName=[{}], schemaId=[{}]", new Object[]{appId, shortName, schemaId});
        Swagger swagger = this.loadFromMemory(appId, shortName, schemaId);
        if (swagger != null) {
            LOGGER.info("load schema from memory");
            return swagger;
        }
        return this.loadFromResource(appId, shortName, schemaId);
    }

    @VisibleForTesting
    public Swagger loadFromMemory(String appId, String shortName, String schemaId) {
        return Optional.ofNullable(this.apps.get(appId)).map(microservices -> (Map)microservices.get(shortName)).map(schemas -> (Swagger)schemas.get(schemaId)).orElse(null);
    }

    private Swagger loadFromResource(String appId, String shortName, String schemaId) {
        Swagger swagger;
        if (appId.equals(RegistrationManager.INSTANCE.getMicroservice().getAppId()) && (swagger = this.loadFromResource(String.format("microservices/%s/%s.yaml", shortName, schemaId))) != null) {
            return swagger;
        }
        return this.loadFromResource(String.format("applications/%s/%s/%s.yaml", appId, shortName, schemaId));
    }

    private Swagger loadFromResource(String path) {
        URL url = JvmUtils.findClassLoader().getResource(path);
        if (url == null) {
            return null;
        }
        LOGGER.info("load schema from path [{}]", (Object)path);
        return SwaggerUtils.parseAndValidateSwagger((URL)url);
    }

    private Swagger loadFromRemote(Microservice microservice, Collection<MicroserviceInstance> instances, String schemaId) {
        String schemaContent = DiscoveryManager.INSTANCE.getSchema(microservice.getServiceId(), instances, schemaId);
        if (schemaContent != null) {
            LOGGER.info("load schema from service center, appId={}, microserviceName={}, version={}, serviceId={}, schemaId={}.", new Object[]{microservice.getAppId(), microservice.getServiceName(), microservice.getVersion(), microservice.getServiceId(), schemaId});
            LOGGER.debug(schemaContent);
            return SwaggerUtils.parseAndValidateSwagger((String)schemaContent);
        }
        LOGGER.warn("no schema in local, and can not get schema from service center, appId={}, microserviceName={}, version={}, serviceId={}, schemaId={}.", new Object[]{microservice.getAppId(), microservice.getServiceName(), microservice.getVersion(), microservice.getServiceId(), schemaId});
        return null;
    }
}

