/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.bizkeeper;

import com.netflix.config.DynamicPropertyFactory;
import com.netflix.hystrix.HystrixObservableCommand;
import com.netflix.hystrix.strategy.concurrency.HystrixRequestContext;
import org.apache.servicecomb.bizkeeper.FallbackPolicyManager;
import org.apache.servicecomb.core.Invocation;
import org.apache.servicecomb.swagger.invocation.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Observable;

public abstract class BizkeeperCommand
extends HystrixObservableCommand<Response> {
    private static final Logger LOG = LoggerFactory.getLogger(BizkeeperCommand.class);
    private final Invocation invocation;
    private final String type;

    protected BizkeeperCommand(String type, Invocation invocation, HystrixObservableCommand.Setter setter) {
        super(setter);
        this.type = type;
        this.invocation = invocation;
    }

    protected String getCacheKey() {
        if (HystrixRequestContext.isCurrentThreadInitialized()) {
            StringBuilder sb = new StringBuilder();
            sb.append(this.getCommandGroup().name());
            sb.append("-");
            sb.append(this.getCommandKey().name());
            return sb.toString();
        }
        return super.getCacheKey();
    }

    protected Observable<Response> resumeWithFallback() {
        Throwable cause = this.getFailedExecutionException();
        Observable observable = Observable.create(f -> {
            try {
                f.onNext((Object)FallbackPolicyManager.getFallbackResponse(this.type, cause, this.invocation));
                f.onCompleted();
            }
            catch (Exception e) {
                if (DynamicPropertyFactory.getInstance().getBooleanProperty("servicecomb.error.printSensitiveErrorMessage", false).get()) {
                    LOG.warn("fallback failed.", (Throwable)e);
                } else {
                    LOG.warn("fallback failed due to: {}", (Object)e.getMessage());
                }
                throw e;
            }
        });
        return observable;
    }

    protected Observable<Response> construct() {
        Observable observable = Observable.create(f -> {
            try {
                this.invocation.next(resp -> {
                    if (this.isFailedResponse(resp)) {
                        LOG.warn("bizkeeper command {} failed, trace id {} result {}", new Object[]{this.invocation.getInvocationQualifiedName(), this.invocation.getTraceId(), resp.getResult()});
                        f.onError((Throwable)resp.getResult());
                        FallbackPolicyManager.record(this.type, this.invocation, resp, false);
                    } else {
                        f.onNext((Object)resp);
                        f.onCompleted();
                        FallbackPolicyManager.record(this.type, this.invocation, resp, true);
                    }
                });
            }
            catch (Exception e) {
                LOG.warn("bizkeeper command {} execute failed, trace id {}, cause {}", new Object[]{this.invocation.getInvocationQualifiedName(), this.invocation.getTraceId(), e.getClass().getName()});
                f.onError((Throwable)e);
            }
        });
        return observable;
    }

    protected abstract boolean isFailedResponse(Response var1);
}

