/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.swagger.generator.core.model;

import io.swagger.models.HttpMethod;
import io.swagger.models.Operation;
import io.swagger.models.Path;
import io.swagger.models.Swagger;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.servicecomb.swagger.generator.SwaggerGenerator;
import org.apache.servicecomb.swagger.generator.core.model.SwaggerOperation;

public class SwaggerOperations {
    private Swagger swagger;
    private Map<String, SwaggerOperation> operations = new HashMap<String, SwaggerOperation>();

    public static SwaggerOperations generate(Class<?> cls) {
        Swagger swagger = SwaggerGenerator.create(cls).generate();
        return new SwaggerOperations(swagger);
    }

    public SwaggerOperations(Swagger swagger) {
        this.swagger = swagger;
        Map paths = swagger.getPaths();
        if (paths == null) {
            return;
        }
        for (Map.Entry pathEntry : paths.entrySet()) {
            for (Map.Entry operationEntry : ((Path)pathEntry.getValue()).getOperationMap().entrySet()) {
                Operation operation = (Operation)operationEntry.getValue();
                if (StringUtils.isEmpty((CharSequence)operation.getOperationId())) {
                    throw new IllegalStateException(String.format("OperationId can not be empty, path=%s, httpMethod=%s.", pathEntry.getKey(), operationEntry.getKey()));
                }
                SwaggerOperation swaggerOperation = new SwaggerOperation(swagger, (String)pathEntry.getKey(), (HttpMethod)operationEntry.getKey(), operation);
                if (this.operations.putIfAbsent(operation.getOperationId(), swaggerOperation) == null) continue;
                throw new IllegalStateException("please make sure operationId is unique, duplicated operationId is " + operation.getOperationId());
            }
        }
    }

    public Swagger getSwagger() {
        return this.swagger;
    }

    public SwaggerOperation findOperation(String operationId) {
        return this.operations.get(operationId);
    }

    public Map<String, SwaggerOperation> getOperations() {
        return this.operations;
    }
}

