/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.governance.properties;

import com.google.common.eventbus.Subscribe;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.servicecomb.governance.MicroserviceMeta;
import org.apache.servicecomb.governance.entity.Configurable;
import org.apache.servicecomb.governance.event.GovernanceConfigurationChangedEvent;
import org.apache.servicecomb.governance.event.GovernanceEventManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.CompositePropertySource;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertySource;
import org.springframework.util.CollectionUtils;
import org.yaml.snakeyaml.TypeDescription;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.Constructor;
import org.yaml.snakeyaml.representer.Representer;

public abstract class GovernanceProperties<T extends Configurable>
implements InitializingBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(GovernanceProperties.class);
    private final Representer representer = new Representer();
    private final String configKey;
    @Autowired
    protected Environment environment;
    @Autowired
    private MicroserviceMeta microserviceMeta;
    protected Map<String, T> parsedEntity;
    protected Class<T> entityClass;

    protected GovernanceProperties(String key) {
        this.configKey = key;
        this.representer.getPropertyUtils().setSkipMissingProperties(true);
        GovernanceEventManager.register(this);
        this.entityClass = this.getEntityClass();
    }

    public void afterPropertiesSet() {
        this.parsedEntity = this.parseEntity(this.readPropertiesFromPrefix());
    }

    @Subscribe
    public void onConfigurationChangedEvent(GovernanceConfigurationChangedEvent event) {
        for (String key : event.getChangedConfigurations()) {
            if (!key.startsWith(this.configKey + ".")) continue;
            String mapKey = key.substring((this.configKey + ".").length());
            this.parsedEntity.remove(mapKey);
            T entityItem = this.parseEntityItem(mapKey, this.environment.getProperty(key));
            if (entityItem == null) continue;
            this.parsedEntity.put(mapKey, entityItem);
        }
    }

    private Map<String, String> readPropertiesFromPrefix() {
        Set<String> allKeys = this.getAllKeys(this.environment);
        HashMap<String, String> result = new HashMap<String, String>();
        allKeys.forEach(key -> {
            if (key.startsWith(this.configKey + ".")) {
                result.put(key.substring(this.configKey.length() + 1), this.environment.getProperty(key));
            }
        });
        return result;
    }

    private Set<String> getAllKeys(Environment environment) {
        HashSet<String> allKeys = new HashSet<String>();
        if (!(environment instanceof ConfigurableEnvironment)) {
            return allKeys;
        }
        ConfigurableEnvironment configurableEnvironment = (ConfigurableEnvironment)environment;
        for (PropertySource propertySource : configurableEnvironment.getPropertySources()) {
            this.getProperties(propertySource, allKeys);
        }
        return allKeys;
    }

    private void getProperties(PropertySource<?> propertySource, Set<String> allKeys) {
        if (propertySource instanceof CompositePropertySource) {
            CompositePropertySource compositePropertySource = (CompositePropertySource)propertySource;
            compositePropertySource.getPropertySources().forEach(ps -> this.getProperties((PropertySource<?>)ps, allKeys));
            return;
        }
        if (propertySource instanceof EnumerablePropertySource) {
            EnumerablePropertySource enumerablePropertySource = (EnumerablePropertySource)propertySource;
            Collections.addAll(allKeys, enumerablePropertySource.getPropertyNames());
            return;
        }
        LOGGER.debug("None EnumerablePropertySource ignored in {}, propertySourceName = [{}]", (Object)this.getClass().getName(), (Object)propertySource.getName());
    }

    public Map<String, T> getParsedEntity() {
        return this.parsedEntity;
    }

    protected Map<String, T> parseEntity(Map<String, String> yamlEntity) {
        if (CollectionUtils.isEmpty(yamlEntity)) {
            return new HashMap();
        }
        HashMap<String, T> resultMap = new HashMap<String, T>();
        for (Map.Entry<String, String> entry : yamlEntity.entrySet()) {
            T marker = this.parseEntityItem(entry.getKey(), entry.getValue());
            if (marker == null) continue;
            resultMap.put(entry.getKey(), marker);
        }
        return resultMap;
    }

    protected abstract Class<T> getEntityClass();

    protected T parseEntityItem(String key, String value) {
        if (StringUtils.isEmpty((CharSequence)value)) {
            return null;
        }
        try {
            Yaml entityParser = new Yaml((BaseConstructor)new Constructor(new TypeDescription(this.entityClass, this.entityClass)), this.representer);
            Configurable result = (Configurable)entityParser.loadAs(value, this.entityClass);
            result.setName(key);
            if (!result.isValid()) {
                LOGGER.warn("Entity configuration is not valid and ignored. Key [{}], value [{}]", (Object)key, (Object)value);
                return null;
            }
            if (!this.servicesMatch(result.getServices())) {
                LOGGER.info("Configuration belongs to other service is ignored. Key [{}]", (Object)key);
                return null;
            }
            return (T)result;
        }
        catch (RuntimeException e) {
            LOGGER.error("governance config yaml is illegal : {}", (Object)e.getMessage());
            return null;
        }
    }

    private boolean servicesMatch(String services) {
        if (StringUtils.isEmpty((CharSequence)services)) {
            return true;
        }
        return Arrays.stream(services.split(",")).anyMatch(ser -> {
            String[] serviceAndVersion = ser.split(":");
            if (serviceAndVersion.length == 1) {
                return this.microserviceMeta.getName().equals(serviceAndVersion[0]);
            }
            if (serviceAndVersion.length == 2) {
                return this.microserviceMeta.getName().equals(serviceAndVersion[0]) && this.microserviceMeta.getVersion().equals(serviceAndVersion[1]);
            }
            return false;
        });
    }
}

