/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.darklaunch.oper;

import org.apache.servicecomb.darklaunch.oper.Condition;
import org.apache.servicecomb.darklaunch.oper.SupportedType;

public abstract class AbstractCondition
implements Condition {
    private String key;
    private String expected;
    private Object actual;
    private SupportedType type = SupportedType.UNKNOWN;

    public AbstractCondition(String key, String expected) {
        this.assertValueNotNull(key, expected);
        this.key = key;
        this.expected = expected;
    }

    @Override
    public String key() {
        return this.key;
    }

    @Override
    public String expected() {
        return this.expected;
    }

    @Override
    public void setActual(String key, Object actual) {
        this.assertValueNotNull(key, "");
        if (this.key.equals(key)) {
            if (actual instanceof String) {
                this.type = SupportedType.STRING;
            } else if (actual instanceof Number) {
                this.type = SupportedType.NUMBER;
            }
            this.actual = actual;
        }
    }

    protected void assertValueNotNull(String key, Object value) {
        if (key == null) {
            throw new IllegalArgumentException("Key can not be null.");
        }
        if (value == null) {
            throw new IllegalArgumentException("Argument can not be null. key = " + key);
        }
    }

    public static int compareNum(Object num, String anotherNum) {
        try {
            if (num instanceof Integer) {
                return ((Integer)num).compareTo(Integer.valueOf(anotherNum));
            }
            if (num instanceof Long) {
                return ((Long)num).compareTo(Long.valueOf(anotherNum));
            }
            if (num instanceof Double) {
                return ((Double)num).compareTo(Double.valueOf(anotherNum));
            }
            if (num instanceof Float) {
                return ((Float)num).compareTo(Float.valueOf(anotherNum));
            }
        }
        catch (NumberFormatException e) {
            return 1;
        }
        return 1;
    }

    public Object getActual() {
        return this.actual;
    }

    public SupportedType getType() {
        return this.type;
    }
}

