/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.handler.governance;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import org.apache.servicecomb.core.Invocation;
import org.apache.servicecomb.governance.marker.GovernanceRequest;

public final class MatchType {
    public static final String REST = "rest";
    public static final String RPC = "rpc";

    public static GovernanceRequest createGovHttpRequest(Invocation invocation) {
        GovernanceRequest request = new GovernanceRequest();
        if (REST.equalsIgnoreCase(invocation.getOperationMeta().getConfig().getGovernanceMatchType())) {
            if (invocation.isConsumer()) {
                request.setUri(invocation.getSchemaMeta().getSwagger().getBasePath() + invocation.getOperationMeta().getOperationPath());
                request.setMethod(invocation.getOperationMeta().getHttpMethod());
                request.setHeaders(MatchType.getHeaderMap(invocation, true));
                return request;
            }
            request.setUri(invocation.getRequestEx().getRequestURI());
            request.setMethod(invocation.getRequestEx().getMethod());
            request.setHeaders(MatchType.getHeaderMap(invocation, false));
            return request;
        }
        if (invocation.isConsumer()) {
            request.setUri(invocation.getOperationMeta().getMicroserviceQualifiedName());
        } else {
            request.setUri(invocation.getOperationMeta().getSchemaQualifiedName());
        }
        request.setMethod(invocation.getOperationMeta().getHttpMethod());
        request.setHeaders(MatchType.getHeaderMap(invocation, true));
        return request;
    }

    private static Map<String, String> getHeaderMap(Invocation invocation, boolean fromContext) {
        HashMap<String, String> headers = new HashMap<String, String>();
        if (fromContext) {
            headers.putAll(invocation.getContext());
        } else {
            Enumeration names = invocation.getRequestEx().getHeaderNames();
            while (names.hasMoreElements()) {
                String name = (String)names.nextElement();
                if (invocation.getRequestEx().getHeader(name) == null) continue;
                headers.put(name, invocation.getRequestEx().getHeader(name));
            }
        }
        Map arguments = invocation.getSwaggerArguments();
        if (arguments != null) {
            arguments.forEach((k, v) -> {
                if (v != null) {
                    headers.put((String)k, v.toString());
                }
            });
        }
        return headers;
    }
}

