/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.transport.rest.client;

import io.vertx.core.Future;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.RequestOptions;
import javax.ws.rs.core.Response;
import org.apache.servicecomb.common.rest.definition.RestMetaUtils;
import org.apache.servicecomb.common.rest.definition.RestOperationMeta;
import org.apache.servicecomb.core.Invocation;
import org.apache.servicecomb.core.definition.OperationMeta;
import org.apache.servicecomb.foundation.common.net.URIEndpointObject;
import org.apache.servicecomb.foundation.vertx.client.http.HttpClientWithContext;
import org.apache.servicecomb.foundation.vertx.client.http.HttpClients;
import org.apache.servicecomb.swagger.invocation.exception.InvocationException;
import org.apache.servicecomb.transport.rest.client.BoundaryFactory;
import org.apache.servicecomb.transport.rest.client.HttpClientRequestFactory;
import org.apache.servicecomb.transport.rest.client.RestClientTransportContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class RestClientTransportContextFactory {
    private BoundaryFactory boundaryFactory = BoundaryFactory.DEFAULT;
    private HttpClientRequestFactory httpClientRequestFactory = HttpClientRequestFactory.DEFAULT;

    @Autowired(required=false)
    public RestClientTransportContextFactory setBoundaryFactory(BoundaryFactory boundaryFactory) {
        this.boundaryFactory = boundaryFactory;
        return this;
    }

    @Autowired(required=false)
    public RestClientTransportContextFactory setHttpClientRequestFactory(HttpClientRequestFactory factory) {
        this.httpClientRequestFactory = factory;
        return this;
    }

    public RestClientTransportContext create(Invocation invocation, HttpClientRequest httpClientRequest) {
        try {
            return this.doCreate(invocation, httpClientRequest);
        }
        catch (Throwable e) {
            throw new InvocationException((Response.StatusType)Response.Status.BAD_REQUEST, "scb_rest_client.40000000", e.getMessage(), e);
        }
    }

    protected RestClientTransportContext doCreate(Invocation invocation, HttpClientRequest httpClientRequest) throws Throwable {
        RestOperationMeta restOperationMeta = RestMetaUtils.getRestOperationMeta((OperationMeta)invocation.getOperationMeta());
        HttpClientWithContext httpClientWithContext = this.findHttpClientPool(invocation);
        return new RestClientTransportContext(restOperationMeta, httpClientWithContext.context(), httpClientRequest, this.boundaryFactory);
    }

    protected HttpClientWithContext findHttpClientPool(Invocation invocation) {
        URIEndpointObject endpoint = (URIEndpointObject)invocation.getEndpoint().getAddress();
        if (endpoint.isHttp2Enabled()) {
            return HttpClients.getClient((String)"http2-transport-client", (boolean)invocation.isSync());
        }
        return HttpClients.getClient((String)"http-transport-client", (boolean)invocation.isSync());
    }

    protected Future<HttpClientRequest> createHttpClientRequest(Invocation invocation) {
        try {
            RestOperationMeta restOperationMeta = RestMetaUtils.getRestOperationMeta((OperationMeta)invocation.getOperationMeta());
            HttpClientWithContext httpClientWithContext = this.findHttpClientPool(invocation);
            URIEndpointObject endpoint = (URIEndpointObject)invocation.getEndpoint().getAddress();
            HttpMethod method = HttpMethod.valueOf((String)restOperationMeta.getHttpMethod());
            RequestOptions requestOptions = new RequestOptions().setHost(endpoint.getHostOrIp()).setPort(Integer.valueOf(endpoint.getPort())).setSsl(Boolean.valueOf(endpoint.isSslEnabled())).setMethod(method).setURI(this.createRequestPath(invocation, restOperationMeta));
            return this.httpClientRequestFactory.create(invocation, httpClientWithContext.getHttpClient(), requestOptions);
        }
        catch (Throwable e) {
            throw new InvocationException((Response.StatusType)Response.Status.BAD_REQUEST, "scb_rest_client.40000000", e.getMessage(), e);
        }
    }

    protected String createRequestPath(Invocation invocation, RestOperationMeta restOperationMeta) throws Exception {
        URIEndpointObject endpoint;
        String urlPrefix;
        String path = (String)invocation.getLocalContext("rest-client-request-path");
        if (path == null) {
            path = restOperationMeta.getPathBuilder().createRequestPath(invocation.getSwaggerArguments());
        }
        if (StringUtils.isEmpty((Object)(urlPrefix = (endpoint = (URIEndpointObject)invocation.getEndpoint().getAddress()).getFirst("urlPrefix"))) || path.startsWith(urlPrefix)) {
            return path;
        }
        return urlPrefix + path;
    }
}

