/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.config.nacos.client;

import com.alibaba.nacos.api.NacosFactory;
import com.alibaba.nacos.api.config.ConfigService;
import com.alibaba.nacos.api.config.listener.Listener;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import org.apache.commons.lang3.StringUtils;
import org.apache.servicecomb.config.nacos.archaius.sources.NacosConfigurationSourceImpl;
import org.apache.servicecomb.config.nacos.client.ConfigurationAction;
import org.apache.servicecomb.config.nacos.client.NacosConfig;
import org.apache.servicecomb.config.parser.Parser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NacosClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(NacosClient.class);
    private static final Map<String, Object> originalConfigMap = new ConcurrentHashMap<String, Object>();
    private final NacosConfigurationSourceImpl.UpdateHandler updateHandler;

    public NacosClient(NacosConfigurationSourceImpl.UpdateHandler updateHandler) {
        this.updateHandler = updateHandler;
    }

    public void refreshNacosConfig() {
        new ConfigRefresh().refreshConfig();
    }

    class ConfigRefresh {
        Parser contentParser = Parser.findParser((String)NacosConfig.INSTANCE.getContentType());
        String keyPrefix = NacosConfig.INSTANCE.getGroup() + "." + NacosConfig.INSTANCE.getDataId();

        ConfigRefresh() {
        }

        void refreshConfig() {
            Properties properties = new Properties();
            properties.put("serverAddr", NacosConfig.INSTANCE.getServerAddr());
            properties.put("namespace", NacosConfig.INSTANCE.getNameSpace());
            try {
                ConfigService configService = NacosFactory.createConfigService((Properties)properties);
                String content = configService.getConfig(NacosConfig.INSTANCE.getDataId(), NacosConfig.INSTANCE.getGroup(), 5000L);
                this.processContent(content);
                configService.addListener(NacosConfig.INSTANCE.getDataId(), NacosConfig.INSTANCE.getGroup(), new Listener(){

                    public void receiveConfigInfo(String configInfo) {
                        LOGGER.info("receive from nacos:" + configInfo);
                        ConfigRefresh.this.processContent(configInfo);
                    }

                    public Executor getExecutor() {
                        return null;
                    }
                });
            }
            catch (Exception e) {
                LOGGER.error("Receive nacos config error: ", (Throwable)e);
            }
        }

        private void processContent(String content) {
            if (StringUtils.isEmpty((CharSequence)content)) {
                return;
            }
            this.refreshConfigItems(this.contentParser.parse(content, this.keyPrefix, NacosConfig.INSTANCE.getAddPrefix()));
        }

        private void refreshConfigItems(Map<String, Object> map) {
            this.compareChangedConfig(originalConfigMap, map);
            originalConfigMap.clear();
            originalConfigMap.putAll(map);
        }

        void compareChangedConfig(Map<String, Object> before, Map<String, Object> after) {
            HashMap<String, Object> itemsCreated = new HashMap<String, Object>();
            HashMap<String, Object> itemsDeleted = new HashMap<String, Object>();
            HashMap<String, Object> itemsModified = new HashMap<String, Object>();
            if (before == null || before.isEmpty()) {
                NacosClient.this.updateHandler.handle(ConfigurationAction.CREATE, after);
                return;
            }
            if (after == null || after.isEmpty()) {
                NacosClient.this.updateHandler.handle(ConfigurationAction.DELETE, before);
                return;
            }
            after.entrySet().forEach(stringObjectEntry -> {
                String itemKey = (String)stringObjectEntry.getKey();
                Object itemValue = stringObjectEntry.getValue();
                if (!before.containsKey(itemKey)) {
                    itemsCreated.put(itemKey, itemValue);
                } else if (!itemValue.equals(before.get(itemKey))) {
                    itemsModified.put(itemKey, itemValue);
                }
            });
            for (String itemKey : before.keySet()) {
                if (after.containsKey(itemKey)) continue;
                itemsDeleted.put(itemKey, "");
            }
            NacosClient.this.updateHandler.handle(ConfigurationAction.CREATE, itemsCreated);
            NacosClient.this.updateHandler.handle(ConfigurationAction.SET, itemsModified);
            NacosClient.this.updateHandler.handle(ConfigurationAction.DELETE, itemsDeleted);
        }
    }
}

