/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.serviceregistry;

import com.google.common.eventbus.Subscribe;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.regex.Matcher;
import org.apache.commons.configuration.Configuration;
import org.apache.servicecomb.config.ConfigUtil;
import org.apache.servicecomb.foundation.common.Holder;
import org.apache.servicecomb.foundation.common.event.EnableExceptionPropagation;
import org.apache.servicecomb.foundation.common.event.EventManager;
import org.apache.servicecomb.foundation.common.utils.BeanUtils;
import org.apache.servicecomb.registry.DiscoveryManager;
import org.apache.servicecomb.registry.api.event.MicroserviceInstanceRegisteredEvent;
import org.apache.servicecomb.registry.api.registry.FindInstancesResponse;
import org.apache.servicecomb.registry.api.registry.Microservice;
import org.apache.servicecomb.registry.api.registry.MicroserviceInstance;
import org.apache.servicecomb.registry.api.registry.MicroserviceInstances;
import org.apache.servicecomb.registry.swagger.SwaggerLoader;
import org.apache.servicecomb.serviceregistry.ServiceRegistry;
import org.apache.servicecomb.serviceregistry.client.ServiceRegistryClient;
import org.apache.servicecomb.serviceregistry.config.ServiceRegistryConfig;
import org.apache.servicecomb.serviceregistry.registry.ServiceRegistryFactory;
import org.apache.servicecomb.serviceregistry.registry.cache.AggregateServiceRegistryCache;
import org.apache.servicecomb.serviceregistry.registry.cache.MicroserviceCache;
import org.apache.servicecomb.serviceregistry.registry.cache.MicroserviceCacheKey;
import org.apache.servicecomb.serviceregistry.task.MicroserviceInstanceRegisterTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public final class RegistryUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(RegistryUtils.class);
    private static volatile ServiceRegistry serviceRegistry;
    private static final Map<String, ServiceRegistry> EXTRA_SERVICE_REGISTRIES;
    private static AggregateServiceRegistryCache aggregateServiceRegistryCache;

    private RegistryUtils() {
    }

    public static synchronized void init() {
        if (serviceRegistry != null) {
            return;
        }
        RegistryUtils.initializeServiceRegistriesWithConfig((Configuration)ConfigUtil.createLocalConfig());
        RegistryUtils.initAggregateServiceRegistryCache();
    }

    private static void initAggregateServiceRegistryCache() {
        ArrayList<ServiceRegistry> serviceRegistries = new ArrayList<ServiceRegistry>();
        RegistryUtils.executeOnEachServiceRegistry(serviceRegistries::add);
        aggregateServiceRegistryCache = new AggregateServiceRegistryCache(serviceRegistries);
        aggregateServiceRegistryCache.setCacheRefreshedWatcher(refreshedCaches -> DiscoveryManager.INSTANCE.getAppManager().pullInstances());
        RegistryUtils.executeOnEachServiceRegistry(serviceRegistry -> serviceRegistry.getEventBus().register((Object)aggregateServiceRegistryCache));
    }

    private static void initializeServiceRegistriesWithConfig(Configuration configuration) {
        serviceRegistry = ServiceRegistryFactory.create(ServiceRegistryConfig.INSTANCE, configuration);
        RegistryUtils.initializeServiceRegistries(configuration);
    }

    private static void initializeServiceRegistries(Configuration configuration) {
        Map configs = BeanUtils.getBeansOfType(ServiceRegistryConfig.class);
        configs.forEach((k, v) -> {
            ServiceRegistry serviceRegistry = ServiceRegistryFactory.create(v, configuration);
            RegistryUtils.addExtraServiceRegistry(serviceRegistry);
        });
        RegistryUtils.executeOnEachServiceRegistry(ServiceRegistry::init);
        RegistryUtils.executeOnEachServiceRegistry(AfterServiceInstanceRegistryHandler::new);
    }

    public static void run() {
        RegistryUtils.executeOnEachServiceRegistry(ServiceRegistry::run);
    }

    public static void destroy() {
        RegistryUtils.executeOnEachServiceRegistry(ServiceRegistry::destroy);
    }

    public static ServiceRegistry getServiceRegistry() {
        return serviceRegistry;
    }

    public static void setServiceRegistry(ServiceRegistry serviceRegistry) {
        RegistryUtils.serviceRegistry = serviceRegistry;
        RegistryUtils.initAggregateServiceRegistryCache();
    }

    @Deprecated
    public static ServiceRegistryClient getServiceRegistryClient() {
        return serviceRegistry.getServiceRegistryClient();
    }

    public static String getAppId() {
        return serviceRegistry.getAppId();
    }

    public static Microservice getMicroservice() {
        return serviceRegistry.getMicroservice();
    }

    public static List<Microservice> getAllMicroservices() {
        return serviceRegistry.getAllMicroservices();
    }

    public static MicroserviceInstance getMicroserviceInstance() {
        return serviceRegistry.getMicroserviceInstance();
    }

    public static List<MicroserviceInstance> findServiceInstance(String appId, String serviceName, String versionRule) {
        MicroserviceCache serviceCache = aggregateServiceRegistryCache.findServiceCache(MicroserviceCacheKey.builder().appId(appId).serviceName(serviceName).env(RegistryUtils.getMicroservice().getEnvironment()).versionRule(versionRule).build());
        return MicroserviceCache.MicroserviceCacheStatus.SERVICE_NOT_FOUND.equals((Object)serviceCache.getStatus()) ? null : serviceCache.getInstances();
    }

    public static boolean updateInstanceProperties(Map<String, String> instanceProperties) {
        Holder resultHolder = new Holder((Object)true);
        RegistryUtils.executeOnEachServiceRegistry(sr -> {
            boolean updateResult = sr.updateInstanceProperties(instanceProperties);
            resultHolder.value = updateResult && (Boolean)resultHolder.value != false;
        });
        return (Boolean)resultHolder.value;
    }

    public static Microservice getMicroservice(String microserviceId) {
        return RegistryUtils.getResultFromFirstValidServiceRegistry(sr -> sr.getRemoteMicroservice(microserviceId));
    }

    public static MicroserviceInstances findServiceInstances(String appId, String serviceName, String versionRule) {
        MicroserviceCache serviceCache = aggregateServiceRegistryCache.findServiceCache(MicroserviceCacheKey.builder().appId(appId).serviceName(serviceName).env(RegistryUtils.getMicroservice().getEnvironment()).versionRule(versionRule).build());
        return RegistryUtils.convertCacheToMicroserviceInstances(serviceCache);
    }

    public static MicroserviceInstances convertCacheToMicroserviceInstances(MicroserviceCache microserviceCache) {
        MicroserviceInstances microserviceInstances = new MicroserviceInstances();
        switch (microserviceCache.getStatus()) {
            case SERVICE_NOT_FOUND: {
                microserviceInstances.setMicroserviceNotExist(true);
                microserviceInstances.setNeedRefresh(false);
                microserviceInstances.setRevision("");
                microserviceInstances.setInstancesResponse(null);
                return microserviceInstances;
            }
            case NO_CHANGE: {
                microserviceInstances.setMicroserviceNotExist(false);
                microserviceInstances.setNeedRefresh(false);
                microserviceInstances.setRevision(microserviceCache.getRevisionId());
                return microserviceInstances;
            }
            case REFRESHED: {
                microserviceInstances.setMicroserviceNotExist(false);
                microserviceInstances.setNeedRefresh(true);
                microserviceInstances.setRevision(microserviceCache.getRevisionId());
                FindInstancesResponse findInstancesResponse = new FindInstancesResponse();
                findInstancesResponse.setInstances(new ArrayList<MicroserviceInstance>(microserviceCache.getInstances()));
                microserviceInstances.setInstancesResponse(findInstancesResponse);
                return microserviceInstances;
            }
        }
        return null;
    }

    public static String calcSchemaSummary(String schemaContent) {
        return SwaggerLoader.calcSchemaSummary((String)schemaContent);
    }

    public static String getAggregatedSchema(String microserviceId, String schemaId) {
        return RegistryUtils.getResultFromFirstValidServiceRegistry(sr -> sr.getServiceRegistryClient().getAggregatedSchema(microserviceId, schemaId));
    }

    public static Microservice getAggregatedRemoteMicroservice(String microserviceId) {
        return RegistryUtils.getResultFromFirstValidServiceRegistry(sr -> sr.getAggregatedRemoteMicroservice(microserviceId));
    }

    public static <T> T getResultFromFirstValidServiceRegistry(Function<ServiceRegistry, T> action) {
        Holder resultHolder = new Holder();
        RegistryUtils.executeOnEachServiceRegistry(sr -> {
            if (null == resultHolder.value) {
                resultHolder.value = action.apply((ServiceRegistry)sr);
            }
        });
        return (T)resultHolder.value;
    }

    public static void executeOnEachServiceRegistry(Consumer<ServiceRegistry> action) {
        if (null != RegistryUtils.getServiceRegistry()) {
            action.accept(RegistryUtils.getServiceRegistry());
        }
        if (!EXTRA_SERVICE_REGISTRIES.isEmpty()) {
            EXTRA_SERVICE_REGISTRIES.forEach((k, v) -> action.accept((ServiceRegistry)v));
        }
    }

    public static void addExtraServiceRegistry(ServiceRegistry serviceRegistry) {
        Objects.requireNonNull(serviceRegistry);
        String serviceRegistryName = serviceRegistry.getName();
        if (serviceRegistryName.equals("Default")) {
            LOGGER.error("Registry name cannot be same as default registry name!");
            throw new IllegalArgumentException("Registry Name Duplicated");
        }
        if (EXTRA_SERVICE_REGISTRIES.containsKey(serviceRegistryName)) {
            LOGGER.error("Registry {} is duplicated between implementation {} and {}, please set different names for each implementations", new Object[]{serviceRegistryName, serviceRegistry.getClass().getName(), EXTRA_SERVICE_REGISTRIES.get(serviceRegistryName).getClass().getName()});
            throw new IllegalArgumentException("Registry Name Duplicated");
        }
        LOGGER.info("extra ServiceRegistry added: [{}], [{}]", (Object)serviceRegistryName, serviceRegistry.getClass());
        EXTRA_SERVICE_REGISTRIES.put(serviceRegistryName, serviceRegistry);
    }

    public static void validateRegistryName(String name) {
        Objects.requireNonNull(name, "null value is not allowed for the name of ServiceRegistry");
        Matcher checkMatcher = ServiceRegistry.REGISTRY_NAME_PATTERN.matcher(name);
        boolean isNameValid = checkMatcher.matches();
        if (!isNameValid) {
            throw new IllegalArgumentException("Illegal registry name, the format should be [a-zA-Z]([-_]?[a-zA-Z0-9])+");
        }
    }

    public static ServiceRegistry getServiceRegistry(String registryName) {
        if ("Default".equals(registryName)) {
            return RegistryUtils.getServiceRegistry();
        }
        return EXTRA_SERVICE_REGISTRIES.get(registryName);
    }

    static /* synthetic */ Map access$000() {
        return EXTRA_SERVICE_REGISTRIES;
    }

    static {
        EXTRA_SERVICE_REGISTRIES = new LinkedHashMap<String, ServiceRegistry>();
    }

    public static class AfterServiceInstanceRegistryHandler {
        private static AtomicInteger instanceRegisterCounter = new AtomicInteger(RegistryUtils.access$000().size() + 1);
        private ServiceRegistry serviceRegistry;

        AfterServiceInstanceRegistryHandler(ServiceRegistry serviceRegistry) {
            this.serviceRegistry = serviceRegistry;
            serviceRegistry.getEventBus().register((Object)this);
        }

        @Subscribe
        @EnableExceptionPropagation
        public void afterRegistryInstance(MicroserviceInstanceRegisterTask microserviceInstanceRegisterTask) {
            LOGGER.info("receive MicroserviceInstanceRegisterTask event of [{}]", (Object)this.serviceRegistry.getName());
            if (StringUtils.isEmpty((Object)this.serviceRegistry.getMicroserviceInstance().getInstanceId())) {
                return;
            }
            LOGGER.info("ServiceRegistry[{}] has completed instance registry", (Object)this.serviceRegistry.getName());
            EventManager.unregister((Object)this);
            if (instanceRegisterCounter.decrementAndGet() > 0) {
                return;
            }
            EventManager.getEventBus().post((Object)new MicroserviceInstanceRegisteredEvent("service center registration", this.serviceRegistry.getMicroserviceInstance().getInstanceId(), false));
        }
    }
}

