/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.router;

import com.netflix.loadbalancer.Server;
import java.util.List;
import java.util.Map;
import javax.validation.constraints.NotNull;
import org.apache.servicecomb.router.cache.RouterRuleCache;
import org.apache.servicecomb.router.distribute.RouterDistributor;
import org.apache.servicecomb.router.match.RouterRuleMatcher;
import org.apache.servicecomb.router.model.PolicyRuleItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class RouterFilter {
    private static final Logger LOGGER = LoggerFactory.getLogger(RouterFilter.class);

    public static <T extends Server, E> List<T> getFilteredListOfServers(List<T> list, String targetServiceName, @NotNull Map<String, String> headers, RouterDistributor<T, E> distributer) {
        if (CollectionUtils.isEmpty(list)) {
            return list;
        }
        if (StringUtils.isEmpty((Object)targetServiceName)) {
            return list;
        }
        if (!RouterRuleCache.doInit(targetServiceName)) {
            LOGGER.debug("route management init failed");
            return list;
        }
        PolicyRuleItem invokeRule = RouterRuleMatcher.getInstance().match(targetServiceName, headers);
        if (invokeRule == null) {
            LOGGER.debug("route management match rule failed");
            return list;
        }
        LOGGER.debug("route management match rule success: {}", (Object)invokeRule);
        List<T> resultList = distributer.distribute(targetServiceName, list, invokeRule);
        LOGGER.debug("route management distribute rule success: {}", resultList);
        return resultList;
    }
}

