/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.transport.rest.client;

import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.RequestOptions;
import javax.ws.rs.core.Response;
import org.apache.servicecomb.common.rest.definition.RestMetaUtils;
import org.apache.servicecomb.common.rest.definition.RestOperationMeta;
import org.apache.servicecomb.core.Invocation;
import org.apache.servicecomb.core.definition.OperationMeta;
import org.apache.servicecomb.foundation.common.net.URIEndpointObject;
import org.apache.servicecomb.foundation.vertx.client.http.HttpClientWithContext;
import org.apache.servicecomb.foundation.vertx.client.http.HttpClients;
import org.apache.servicecomb.swagger.invocation.exception.InvocationException;
import org.apache.servicecomb.transport.rest.client.BoundaryFactory;
import org.apache.servicecomb.transport.rest.client.HttpClientRequestFactory;
import org.apache.servicecomb.transport.rest.client.RestClientTransportContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class RestClientTransportContextFactory {
    private BoundaryFactory boundaryFactory = BoundaryFactory.DEFAULT;
    private HttpClientRequestFactory httpClientRequestFactory = HttpClientRequestFactory.DEFAULT;

    @Autowired(required=false)
    public RestClientTransportContextFactory setBoundaryFactory(BoundaryFactory boundaryFactory) {
        this.boundaryFactory = boundaryFactory;
        return this;
    }

    @Autowired(required=false)
    public RestClientTransportContextFactory setHttpClientRequestFactory(HttpClientRequestFactory factory) {
        this.httpClientRequestFactory = factory;
        return this;
    }

    public RestClientTransportContext create(Invocation invocation) {
        try {
            return this.doCreate(invocation);
        }
        catch (Exception e) {
            throw new InvocationException((Response.StatusType)Response.Status.BAD_REQUEST, "scb_rest_client.40000000", e.getMessage(), (Throwable)e);
        }
    }

    protected RestClientTransportContext doCreate(Invocation invocation) throws Exception {
        RestOperationMeta restOperationMeta = RestMetaUtils.getRestOperationMeta((OperationMeta)invocation.getOperationMeta());
        HttpClientWithContext httpClientWithContext = this.findHttpClientPool(invocation);
        HttpClientRequest httpClientRequest = this.createHttpClientRequest(invocation, restOperationMeta, httpClientWithContext.getHttpClient());
        return new RestClientTransportContext(restOperationMeta, httpClientWithContext.context(), httpClientRequest, this.boundaryFactory);
    }

    protected HttpClientWithContext findHttpClientPool(Invocation invocation) {
        URIEndpointObject endpoint = (URIEndpointObject)invocation.getEndpoint().getAddress();
        if (endpoint.isHttp2Enabled()) {
            return HttpClients.getClient((String)"http2-transport-client", (boolean)invocation.isSync());
        }
        return HttpClients.getClient((String)"http-transport-client", (boolean)invocation.isSync());
    }

    protected HttpClientRequest createHttpClientRequest(Invocation invocation, RestOperationMeta restOperationMeta, HttpClient httpClient) throws Exception {
        URIEndpointObject endpoint = (URIEndpointObject)invocation.getEndpoint().getAddress();
        RequestOptions requestOptions = new RequestOptions().setHost(endpoint.getHostOrIp()).setPort(endpoint.getPort()).setSsl(Boolean.valueOf(endpoint.isSslEnabled())).setURI(this.createRequestPath(invocation, restOperationMeta));
        HttpMethod method = HttpMethod.valueOf((String)restOperationMeta.getHttpMethod());
        return this.httpClientRequestFactory.create(invocation, httpClient, method, requestOptions);
    }

    protected String createRequestPath(Invocation invocation, RestOperationMeta restOperationMeta) throws Exception {
        URIEndpointObject endpoint;
        String urlPrefix;
        String path = (String)invocation.getLocalContext("rest-client-request-path");
        if (path == null) {
            path = restOperationMeta.getPathBuilder().createRequestPath(invocation.getSwaggerArguments());
        }
        if (StringUtils.isEmpty((Object)(urlPrefix = (endpoint = (URIEndpointObject)invocation.getEndpoint().getAddress()).getFirst("urlPrefix"))) || path.startsWith(urlPrefix)) {
            return path;
        }
        return urlPrefix + path;
    }
}

