/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.governance.policy;

import io.github.resilience4j.circuitbreaker.CircuitBreakerConfig;
import org.apache.servicecomb.governance.policy.AbstractPolicy;
import org.springframework.util.StringUtils;

public class CircuitBreakerPolicy
extends AbstractPolicy {
    public static final int DEFAULT_FAILURE_RATE_THRESHOLD = 50;
    public static final int DEFAULT_SLOW_CALL_RATE_THRESHOLD = 100;
    public static final int DEFAULT_WAIT_DURATION_IN_OPEN_STATUS = 60000;
    public static final int DEFAULT_SLOW_CALL_DURATION_THRESHOLD = 60000;
    public static final int DEFAULT_PERMITTED = 10;
    public static final int DEFAULT_MINIMUM_NUMBER_CALLS = 100;
    public static final int DEFAULT_SLIDING_WINDOW_SIZE = 100;
    private int failureRateThreshold = 50;
    private int slowCallRateThreshold = 100;
    private int waitDurationInOpenState = 60000;
    private int slowCallDurationThreshold = 60000;
    private int permittedNumberOfCallsInHalfOpenState = 10;
    private int minimumNumberOfCalls = 100;
    private String slidingWindowType;
    private int slidingWindowSize = 100;

    @Override
    public boolean isValid() {
        if (this.failureRateThreshold > 100 || this.failureRateThreshold <= 0) {
            return false;
        }
        if (this.slowCallRateThreshold > 100 || this.slowCallRateThreshold <= 0) {
            return false;
        }
        if (this.waitDurationInOpenState <= 0) {
            return false;
        }
        if (this.slowCallDurationThreshold <= 0) {
            return false;
        }
        if (this.permittedNumberOfCallsInHalfOpenState <= 0) {
            return false;
        }
        if (this.minimumNumberOfCalls <= 0) {
            return false;
        }
        return super.isValid();
    }

    public int getFailureRateThreshold() {
        return this.failureRateThreshold;
    }

    public void setFailureRateThreshold(int failureRateThreshold) {
        this.failureRateThreshold = failureRateThreshold;
    }

    public int getSlowCallRateThreshold() {
        return this.slowCallRateThreshold;
    }

    public void setSlowCallRateThreshold(int slowCallRateThreshold) {
        this.slowCallRateThreshold = slowCallRateThreshold;
    }

    public int getWaitDurationInOpenState() {
        return this.waitDurationInOpenState;
    }

    public void setWaitDurationInOpenState(int waitDurationInOpenState) {
        this.waitDurationInOpenState = waitDurationInOpenState;
    }

    public int getSlowCallDurationThreshold() {
        return this.slowCallDurationThreshold;
    }

    public void setSlowCallDurationThreshold(int slowCallDurationThreshold) {
        this.slowCallDurationThreshold = slowCallDurationThreshold;
    }

    public int getPermittedNumberOfCallsInHalfOpenState() {
        return this.permittedNumberOfCallsInHalfOpenState;
    }

    public void setPermittedNumberOfCallsInHalfOpenState(int permittedNumberOfCallsInHalfOpenState) {
        this.permittedNumberOfCallsInHalfOpenState = permittedNumberOfCallsInHalfOpenState;
    }

    public int getMinimumNumberOfCalls() {
        return this.minimumNumberOfCalls;
    }

    public void setMinimumNumberOfCalls(int minimumNumberOfCalls) {
        this.minimumNumberOfCalls = minimumNumberOfCalls;
    }

    public CircuitBreakerConfig.SlidingWindowType getSlidingWindowTypeEnum() {
        if (StringUtils.isEmpty((Object)this.slidingWindowType)) {
            this.slidingWindowType = "count";
        }
        switch (this.slidingWindowType) {
            case "time": {
                return CircuitBreakerConfig.SlidingWindowType.TIME_BASED;
            }
        }
        return CircuitBreakerConfig.SlidingWindowType.COUNT_BASED;
    }

    public String getSlidingWindowType() {
        return this.slidingWindowType;
    }

    public void setSlidingWindowType(String slidingWindowType) {
        this.slidingWindowType = slidingWindowType;
    }

    public int getSlidingWindowSize() {
        return this.slidingWindowSize;
    }

    public void setSlidingWindowSize(int slidingWindowSize) {
        this.slidingWindowSize = slidingWindowSize;
    }

    public String toString() {
        return "CircuitBreakerPolicy{failureRateThreshold=" + this.failureRateThreshold + ", slowCallRateThreshold=" + this.slowCallRateThreshold + ", waitDurationInOpenState=" + this.waitDurationInOpenState + ", slowCallDurationThreshold=" + this.slowCallDurationThreshold + ", permittedNumberOfCallsInHalfOpenState=" + this.permittedNumberOfCallsInHalfOpenState + ", minimumNumberOfCalls=" + this.minimumNumberOfCalls + ", slidingWindowType='" + this.slidingWindowType + '\'' + ", slidingWindowSize=" + this.slidingWindowSize + '}';
    }
}

