/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.governance;

import java.util.Map;
import org.apache.servicecomb.governance.InvocationContext;
import org.apache.servicecomb.governance.marker.GovernanceRequest;
import org.apache.servicecomb.governance.policy.AbstractPolicy;
import org.apache.servicecomb.governance.service.MatchersService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MatchersManager {
    @Autowired
    private MatchersService matchersService;
    @Autowired
    private InvocationContext invocationContext;

    public <T extends AbstractPolicy> T match(GovernanceRequest request, Map<String, T> policies) {
        Map<String, Boolean> calculatedMatches = this.invocationContext.getCalculatedMatches();
        for (Map.Entry<String, T> entry : policies.entrySet()) {
            AbstractPolicy policy = (AbstractPolicy)entry.getValue();
            if (calculatedMatches.containsKey(entry.getKey())) {
                return (T)policy;
            }
            boolean keyMatch = this.matchersService.checkMatch(request, entry.getKey());
            this.invocationContext.addMatch(entry.getKey(), keyMatch);
            if (!keyMatch) continue;
            return (T)policy;
        }
        return null;
    }
}

