/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.foundation.vertx.client;

import io.vertx.core.Context;
import io.vertx.core.Vertx;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.servicecomb.foundation.vertx.client.ClientPoolFactory;

public class ClientPoolManager<CLIENT_POOL> {
    private Vertx vertx;
    private String id = UUID.randomUUID().toString();
    private ClientPoolFactory<CLIENT_POOL> factory;
    private List<CLIENT_POOL> pools = new CopyOnWriteArrayList<CLIENT_POOL>();
    private AtomicInteger reactiveNextIndex = new AtomicInteger();

    public ClientPoolManager(Vertx vertx, ClientPoolFactory<CLIENT_POOL> factory) {
        this.vertx = vertx;
        this.factory = factory;
    }

    public CLIENT_POOL createClientPool(Context context) {
        CLIENT_POOL pool = this.factory.createClientPool(context);
        this.addPool(context, pool);
        return pool;
    }

    protected void addPool(Context context, CLIENT_POOL pool) {
        context.put(this.id, pool);
        this.pools.add(pool);
    }

    public CLIENT_POOL findClientPool(boolean sync) {
        return this.findClientPool(sync, null);
    }

    public CLIENT_POOL findClientPool(boolean sync, Context targetContext) {
        if (sync) {
            return this.findThreadBindClientPool();
        }
        return this.findByContext(targetContext);
    }

    protected CLIENT_POOL findByContext() {
        return this.findByContext(null);
    }

    protected CLIENT_POOL findByContext(Context targetContext) {
        Context currentContext;
        Context context = currentContext = targetContext != null ? targetContext : Vertx.currentContext();
        if (currentContext != null && currentContext.owner() == this.vertx && currentContext.isEventLoopContext()) {
            Object clientPool = currentContext.get(this.id);
            if (clientPool != null) {
                return (CLIENT_POOL)clientPool;
            }
            return this.createClientPool(currentContext);
        }
        this.assertPoolsInitialized();
        int idx = this.reactiveNextIndex.getAndIncrement() % this.pools.size();
        if (idx < 0) {
            idx = -idx;
        }
        return this.pools.get(idx);
    }

    public CLIENT_POOL findThreadBindClientPool() {
        this.assertPoolsInitialized();
        int idx = (int)(Thread.currentThread().getId() % (long)this.pools.size());
        return this.pools.get(idx);
    }

    private void assertPoolsInitialized() {
        if (this.pools.size() == 0) {
            throw new IllegalStateException("client pool not initialized successfully when making calls.Please check if system boot up is ready or some errors happened when startup.");
        }
    }
}

