/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.config.kie.client.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;

public class KieAddressManager {
    private final Properties properties;
    private final List<String> addresses;
    private final Map<String, String> configKey;
    private int index;

    public KieAddressManager(Properties properties, List<String> addresses, Map<String, String> configKey) {
        this.properties = properties;
        this.addresses = new ArrayList<String>(addresses.size());
        this.configKey = configKey;
        addresses.forEach(address -> this.addresses.add((String)address));
        this.index = new Random().nextInt(addresses.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String nextAddress() {
        KieAddressManager kieAddressManager = this;
        synchronized (kieAddressManager) {
            ++this.index;
            if (this.index >= this.addresses.size()) {
                this.index = 0;
            }
        }
        return this.address();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String address() {
        KieAddressManager kieAddressManager = this;
        synchronized (kieAddressManager) {
            return this.addresses.get(this.index);
        }
    }

    public Properties getProperties() {
        return this.properties;
    }

    public Map<String, String> getConfigKey() {
        return this.configKey;
    }
}

