/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.config.kie.client;

import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang3.StringUtils;
import org.apache.servicecomb.config.kie.client.KieConfigOperation;
import org.apache.servicecomb.config.kie.client.exception.OperationException;
import org.apache.servicecomb.config.kie.client.model.ConfigurationsRequest;
import org.apache.servicecomb.config.kie.client.model.ConfigurationsResponse;
import org.apache.servicecomb.config.kie.client.model.KVDoc;
import org.apache.servicecomb.config.kie.client.model.KVResponse;
import org.apache.servicecomb.config.kie.client.model.KieAddressManager;
import org.apache.servicecomb.config.kie.client.model.ValueType;
import org.apache.servicecomb.http.client.common.HttpRequest;
import org.apache.servicecomb.http.client.common.HttpResponse;
import org.apache.servicecomb.http.client.common.HttpTransport;
import org.apache.servicecomb.http.client.common.HttpUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.YamlPropertiesFactoryBean;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.Resource;

public class KieClient
implements KieConfigOperation {
    private static final Logger LOGGER = LoggerFactory.getLogger(KieClient.class);
    private AtomicBoolean isFirst = new AtomicBoolean(true);
    protected HttpTransport httpTransport;
    protected String revision = "0";
    private String url;
    private HttpResponse httpResponse = null;
    private KieAddressManager addressManager;
    private Map<String, String> labelsMap;
    public static final String DEFAULT_KIE_API_VERSION = "v1";

    public KieClient(KieAddressManager addressManager, HttpTransport httpTransport) {
        this.httpTransport = httpTransport;
        this.addressManager = addressManager;
    }

    @Override
    public ConfigurationsResponse queryConfigurations(ConfigurationsRequest request) {
        boolean isWatch = false;
        if (Boolean.valueOf(this.getPropertiesValue(this.getConfigKeyValue("enableLongPolling"))).booleanValue()) {
            isWatch = true;
        }
        try {
            this.url = this.addressManager.address() + "/" + DEFAULT_KIE_API_VERSION + "/" + this.getPropertiesValue(this.getConfigKeyValue("project")) + "/kie/kv?label=app:" + request.getApplication() + "&revision=" + this.revision;
            if (isWatch && !this.isFirst.get()) {
                this.url = this.url + "&wait=" + this.getPropertiesValue(this.getConfigKeyValue("pollingWaitInSeconds")) + "s";
            }
            this.isFirst.compareAndSet(true, false);
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("environment", request.getEnvironment());
            HttpRequest httpRequest = new HttpRequest(this.url, headers, null, "GET");
            this.httpResponse = this.httpTransport.doRequest(httpRequest);
            if (this.httpResponse == null) {
                return null;
            }
            ConfigurationsResponse configurationsResponse = new ConfigurationsResponse();
            if (this.httpResponse.getStatusCode() == 200) {
                this.revision = this.httpResponse.getHeader("X-Kie-Revision");
                KVResponse allConfigList = (KVResponse)HttpUtils.deserialize((String)this.httpResponse.getContent(), KVResponse.class);
                Map<String, Object> configurations = this.getConfigByLabel(allConfigList, request);
                configurationsResponse.setConfigurations(configurations);
                configurationsResponse.setChanged(true);
                configurationsResponse.setRevision(this.revision);
                return configurationsResponse;
            }
            if (this.httpResponse.getStatusCode() == 400) {
                throw new OperationException("Bad request for query configurations.");
            }
            if (this.httpResponse.getStatusCode() == 304) {
                configurationsResponse.setChanged(false);
                return configurationsResponse;
            }
            throw new OperationException("read response failed. status:" + this.httpResponse.getStatusCode() + "; message:" + this.httpResponse.getMessage() + "; content:" + this.httpResponse.getContent());
        }
        catch (Exception e) {
            this.addressManager.nextAddress();
            throw new OperationException("read response failed. ", e);
        }
    }

    private Map<String, Object> getConfigByLabel(KVResponse resp, ConfigurationsRequest request) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        ArrayList<KVDoc> appList = new ArrayList<KVDoc>();
        ArrayList<KVDoc> serviceList = new ArrayList<KVDoc>();
        ArrayList<KVDoc> versionList = new ArrayList<KVDoc>();
        for (KVDoc kvDoc : resp.getData()) {
            if (!StringUtils.isEmpty((CharSequence)kvDoc.getStatus()) && !kvDoc.getStatus().equals("enabled")) continue;
            this.labelsMap = kvDoc.getLabels();
            boolean checkApplication = this.checkValue("app", request.getApplication());
            boolean checkEnvironment = this.checkValue("environment", request.getEnvironment());
            boolean checkServer = this.checkValue("service", request.getServiceName());
            boolean checkVersion = this.checkValue("version", request.getVersion());
            if (checkApplication && checkEnvironment && !this.labelsMap.containsKey("service")) {
                appList.add(kvDoc);
            }
            if (checkApplication && checkEnvironment && checkServer && !kvDoc.getLabels().containsKey("version")) {
                serviceList.add(kvDoc);
            }
            if (!checkApplication || !checkEnvironment || !checkServer || !checkVersion) continue;
            versionList.add(kvDoc);
        }
        for (KVDoc kvDoc : appList) {
            resultMap.putAll(this.processValueType(kvDoc));
        }
        for (KVDoc kvDoc : serviceList) {
            resultMap.putAll(this.processValueType(kvDoc));
        }
        for (KVDoc kvDoc : versionList) {
            resultMap.putAll(this.processValueType(kvDoc));
        }
        return resultMap;
    }

    private boolean checkValue(String key, String propertyName) {
        if (!this.labelsMap.containsKey(key)) {
            return false;
        }
        return this.labelsMap.get(key).equals(propertyName);
    }

    private Map<String, Object> processValueType(KVDoc kvDoc) {
        ValueType vtype;
        try {
            vtype = ValueType.valueOf(kvDoc.getValueType());
        }
        catch (IllegalArgumentException e) {
            throw new OperationException("value type not support");
        }
        Properties properties = new Properties();
        HashMap<String, Object> kvMap = new HashMap<String, Object>();
        try {
            switch (vtype) {
                case yml: 
                case yaml: {
                    YamlPropertiesFactoryBean yamlFactory = new YamlPropertiesFactoryBean();
                    yamlFactory.setResources(new Resource[]{new ByteArrayResource(kvDoc.getValue().getBytes())});
                    return this.toMap(kvDoc.getKey(), yamlFactory.getObject());
                }
                case properties: {
                    properties.load(new StringReader(kvDoc.getValue()));
                    return this.toMap(kvDoc.getKey(), properties);
                }
            }
            kvMap.put(kvDoc.getKey(), kvDoc.getValue());
            return kvMap;
        }
        catch (Exception e) {
            LOGGER.error("read config failed");
            return Collections.emptyMap();
        }
    }

    private Map<String, Object> toMap(String prefix, Properties properties) {
        if (properties == null) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        Enumeration<?> keys = properties.propertyNames();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            String value = properties.getProperty(key);
            if (!StringUtils.isEmpty((CharSequence)prefix)) {
                key = prefix + "." + key;
            }
            if (value != null) {
                result.put(key, value);
                continue;
            }
            result.put(key, null);
        }
        return result;
    }

    private String getPropertiesValue(String key) {
        return this.addressManager.getProperties().getProperty(key);
    }

    private String getConfigKeyValue(String key) {
        return this.addressManager.getConfigKey().get(key);
    }
}

