/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.swagger.invocation.validator;

import com.netflix.config.DynamicBooleanProperty;
import com.netflix.config.DynamicPropertyFactory;
import java.util.Set;
import javax.validation.ConstraintViolationException;
import javax.validation.MessageInterpolator;
import javax.validation.ParameterNameProvider;
import javax.validation.Validation;
import javax.validation.ValidatorFactory;
import javax.validation.executable.ExecutableValidator;
import javax.validation.groups.Default;
import org.apache.servicecomb.swagger.engine.SwaggerProducerOperation;
import org.apache.servicecomb.swagger.invocation.SwaggerInvocation;
import org.apache.servicecomb.swagger.invocation.extension.ProducerInvokeExtension;
import org.apache.servicecomb.swagger.invocation.validator.DefaultParameterNameProvider;
import org.hibernate.validator.messageinterpolation.AbstractMessageInterpolator;
import org.hibernate.validator.messageinterpolation.ParameterMessageInterpolator;
import org.hibernate.validator.messageinterpolation.ResourceBundleMessageInterpolator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParameterValidator
implements ProducerInvokeExtension {
    private static final Logger LOGGER = LoggerFactory.getLogger(ParameterValidator.class);
    private static final String PARAM_VALIDATION_ENABLED = "servicecomb.rest.parameter.validation.enabled";
    private static final String ENABLE_EL = "servicecomb.filters.validation.useResourceBundleMessageInterpolator";
    private final DynamicBooleanProperty paramValidationEnabled = DynamicPropertyFactory.getInstance().getBooleanProperty("servicecomb.rest.parameter.validation.enabled", true);
    private static ExecutableValidator executableValidator;

    public ParameterValidator() {
        this.paramValidationEnabled.addCallback(() -> {
            boolean newValue = this.paramValidationEnabled.get();
            LOGGER.info("{} changed from {} to {}", new Object[]{PARAM_VALIDATION_ENABLED, this.paramValidationEnabled, newValue});
        });
    }

    public <T> void beforeMethodInvoke(SwaggerInvocation invocation, SwaggerProducerOperation producerOperation, Object[] args) throws ConstraintViolationException {
        if (this.paramValidationEnabled.get()) {
            Set violations;
            if (null == executableValidator) {
                ValidatorFactory factory = Validation.byDefaultProvider().configure().parameterNameProvider((ParameterNameProvider)new DefaultParameterNameProvider()).messageInterpolator((MessageInterpolator)this.messageInterpolator()).buildValidatorFactory();
                executableValidator = factory.getValidator().forExecutables();
            }
            if ((violations = executableValidator.validateParameters(producerOperation.getProducerInstance(), producerOperation.getProducerMethod(), args, new Class[]{Default.class})).size() > 0) {
                LOGGER.warn("Parameter validation failed : " + violations.toString());
                throw new ConstraintViolationException(violations);
            }
        }
    }

    private AbstractMessageInterpolator messageInterpolator() {
        if (this.useResourceBundleMessageInterpolator()) {
            return new ResourceBundleMessageInterpolator();
        }
        return new ParameterMessageInterpolator();
    }

    private boolean useResourceBundleMessageInterpolator() {
        return DynamicPropertyFactory.getInstance().getBooleanProperty(ENABLE_EL, false).get();
    }

    public int getOrder() {
        return 100;
    }
}

