/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.provider.pojo.definition;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.servicecomb.core.definition.MicroserviceMeta;
import org.apache.servicecomb.core.definition.OperationMeta;
import org.apache.servicecomb.core.definition.SchemaMeta;
import org.apache.servicecomb.core.provider.consumer.MicroserviceReferenceConfig;
import org.apache.servicecomb.provider.pojo.definition.PojoConsumerOperationMeta;
import org.apache.servicecomb.swagger.engine.SwaggerConsumer;
import org.apache.servicecomb.swagger.engine.SwaggerConsumerOperation;
import org.apache.servicecomb.swagger.generator.OperationGenerator;
import org.apache.servicecomb.swagger.generator.SwaggerGenerator;

public class PojoConsumerMeta {
    private final MicroserviceReferenceConfig microserviceReferenceConfig;
    private final SchemaMeta schemaMeta;
    private final Map<Method, PojoConsumerOperationMeta> operationMetas = new HashMap<Method, PojoConsumerOperationMeta>();

    public PojoConsumerMeta(MicroserviceReferenceConfig microserviceReferenceConfig, SwaggerConsumer swaggerConsumer, SchemaMeta schemaMeta) {
        this.microserviceReferenceConfig = microserviceReferenceConfig;
        this.schemaMeta = schemaMeta;
        SwaggerGenerator intfSwaggerGenerator = SwaggerGenerator.create((Class)swaggerConsumer.getConsumerIntf());
        intfSwaggerGenerator.scanClassAnnotation();
        for (SwaggerConsumerOperation swaggerConsumerOperation : swaggerConsumer.getOperations().values()) {
            String operationId = swaggerConsumerOperation.getSwaggerOperation().getOperationId();
            OperationMeta operationMeta = schemaMeta.ensureFindOperation(operationId);
            OperationGenerator intfOperationGenerator = intfSwaggerGenerator.createOperationGenerator(swaggerConsumerOperation.getConsumerMethod());
            intfOperationGenerator.generateResponse();
            PojoConsumerOperationMeta pojoConsumerOperationMeta = new PojoConsumerOperationMeta(this, operationMeta, swaggerConsumerOperation);
            this.operationMetas.put(swaggerConsumerOperation.getConsumerMethod(), pojoConsumerOperationMeta);
        }
    }

    public MicroserviceReferenceConfig getMicroserviceReferenceConfig() {
        return this.microserviceReferenceConfig;
    }

    public boolean isExpired() {
        return this.microserviceReferenceConfig.isExpired();
    }

    public MicroserviceMeta getMicroserviceMeta() {
        return this.schemaMeta.getMicroserviceMeta();
    }

    public SchemaMeta getSchemaMeta() {
        return this.schemaMeta;
    }

    @Nonnull
    public PojoConsumerOperationMeta ensureFindOperationMeta(Method method) {
        PojoConsumerOperationMeta pojoConsumerOperationMeta = this.operationMetas.get(method);
        if (pojoConsumerOperationMeta == null) {
            throw new IllegalStateException(String.format("Consumer method %s:%s not exist in contract, microserviceName=%s, schemaId=%s; new producer not running or not deployed.", method.getDeclaringClass().getName(), method.getName(), this.schemaMeta.getMicroserviceName(), this.schemaMeta.getSchemaId()));
        }
        return pojoConsumerOperationMeta;
    }
}

