/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.config.kie.client;

import com.netflix.config.ConcurrentCompositeConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.servicecomb.config.BootStrapProperties;

public class KieConfig {
    public static final KieConfig INSTANCE = new KieConfig();
    private static ConcurrentCompositeConfiguration finalConfig;
    private static final String SERVER_URL_KEY = "servicecomb.kie.serverUri";
    private static final String REFRESH_INTERVAL = "servicecomb.kie.refreshInterval";
    private static final String FIRST_REFRESH_INTERVAL = "servicecomb.kie.firstRefreshInterval";
    private static final String DOMAIN_NAME = "servicecomb.kie.domainName";
    private static final String ENABLE_LONG_POLLING = "servicecomb.kie.enableLongPolling";
    public static final String CONNECTION_TIME_OUT = "servicecomb.kie.client.timeout.connection";
    public static final String EVENT_LOOP_SIZE = "servicecomb.kie.client.eventLoopSize";
    public static final String VERTICAL_INSTANCE_COUNT = "servicecomb.kie.client.verticalInstanceCount";
    public static final String IDLE_TIMEOUT_IN_SECONDES = "servicecomb.kie.client.idleTimeoutInSeconds";
    private static final int DEFAULT_REFRESH_INTERVAL = 3000;
    private static final int DEFAULT_FIRST_REFRESH_INTERVAL = 0;
    private static final boolean DEFAULT_ENABLE_LONG_POLLING = true;

    private KieConfig() {
    }

    public static ConcurrentCompositeConfiguration getFinalConfig() {
        return finalConfig;
    }

    public static void setFinalConfig(ConcurrentCompositeConfiguration finalConfig) {
        KieConfig.finalConfig = finalConfig;
    }

    public int getConnectionTimeOut() {
        return finalConfig.getInt(CONNECTION_TIME_OUT, 1000);
    }

    public int getEventLoopSize() {
        return finalConfig.getInt(EVENT_LOOP_SIZE, 2);
    }

    public int getVerticalInstanceCount() {
        return finalConfig.getInt(VERTICAL_INSTANCE_COUNT, 1);
    }

    public int getIdleTimeoutInSeconds() {
        return finalConfig.getInt(IDLE_TIMEOUT_IN_SECONDES, 60);
    }

    public String getVersion() {
        return BootStrapProperties.readServiceVersion((Configuration)finalConfig);
    }

    public String getServiceName() {
        return BootStrapProperties.readServiceName((Configuration)finalConfig);
    }

    public String getTags() {
        return BootStrapProperties.readServiceInstanceTags((Configuration)finalConfig);
    }

    public String getEnvironment() {
        return BootStrapProperties.readServiceEnvironment((Configuration)finalConfig);
    }

    public String getAppName() {
        return BootStrapProperties.readApplication((Configuration)finalConfig);
    }

    public String getDomainName() {
        return finalConfig.getString(DOMAIN_NAME, "default");
    }

    public String getServerUri() {
        return finalConfig.getString(SERVER_URL_KEY);
    }

    public int getRefreshInterval() {
        return finalConfig.getInt(REFRESH_INTERVAL, 3000);
    }

    public int getFirstRefreshInterval() {
        return finalConfig.getInt(FIRST_REFRESH_INTERVAL, 0);
    }

    public boolean enableLongPolling() {
        return finalConfig.getBoolean(ENABLE_LONG_POLLING, true);
    }

    public Boolean isProxyEnable() {
        return finalConfig.getBoolean("servicecomb.proxy.enable", false);
    }

    public String getProxyHost() {
        return finalConfig.getString("servicecomb.proxy.host", "127.0.0.1");
    }

    public int getProxyPort() {
        return finalConfig.getInt("servicecomb.proxy.port", 8080);
    }

    public String getProxyUsername() {
        return finalConfig.getString("servicecomb.proxy.username", null);
    }

    public String getProxyPasswd() {
        return finalConfig.getString("servicecomb.proxy.passwd", null);
    }
}

