/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.http.client.common;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.entity.StringEntity;

public class HttpRequest {
    public static final String GET = "GET";
    public static final String POST = "POST";
    public static final String DELETE = "DELETE";
    public static final String PUT = "PUT";
    private String method;
    private String url;
    private Map<String, String> headers;
    private String content;

    public HttpRequest(String url, Map<String, String> headers, String content, String method) {
        this.url = url;
        this.headers = headers;
        this.content = content;
        this.method = method;
    }

    public String getUrl() {
        return this.url;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public void addHeader(String name, String value) {
        if (this.headers == null) {
            this.headers = new HashMap<String, String>();
        }
        this.headers.put(name, value);
    }

    public String getContent() {
        return this.content;
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public HttpUriRequest getRealRequest() {
        HttpUriRequest httpUriRequest = null;
        switch (this.method) {
            case "GET": {
                httpUriRequest = new HttpGet(this.url);
                break;
            }
            case "POST": {
                httpUriRequest = new HttpPost(this.url);
                if (this.content == null) break;
                ((HttpPost)httpUriRequest).setEntity((HttpEntity)new StringEntity(this.content, "UTF-8"));
                break;
            }
            case "DELETE": {
                httpUriRequest = new HttpDelete(this.url);
                break;
            }
            case "PUT": {
                httpUriRequest = new HttpPut(this.url);
                if (this.content == null) break;
                ((HttpPut)httpUriRequest).setEntity((HttpEntity)new StringEntity(this.content, "UTF-8"));
                break;
            }
            default: {
                httpUriRequest = RequestBuilder.create((String)this.method).build();
            }
        }
        Optional.ofNullable(httpUriRequest).ifPresent(request -> this.headers.forEach((arg_0, arg_1) -> ((HttpUriRequest)request).addHeader(arg_0, arg_1)));
        return httpUriRequest;
    }
}

