/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.config.priority;

import com.netflix.config.ConfigurationManager;
import com.netflix.config.DynamicPropertyFactory;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.apache.commons.configuration.event.ConfigurationEvent;
import org.apache.commons.configuration.event.ConfigurationListener;
import org.apache.servicecomb.config.inject.ConfigObjectFactory;
import org.apache.servicecomb.config.priority.PriorityProperty;
import org.apache.servicecomb.foundation.common.concurrent.ConcurrentHashMapEx;

public class PriorityPropertyManager {
    private ConfigurationListener configurationListener = this::configurationListener;
    private Set<PriorityProperty<?>> priorityPropertySet = Collections.newSetFromMap(Collections.synchronizedMap(new WeakHashMap()));
    private Map<Object, List<PriorityProperty<?>>> configObjectMap = Collections.synchronizedMap(new WeakHashMap());
    private Map<Object, Map<String, List<PriorityProperty<?>>>> keyCache;

    public PriorityPropertyManager() {
        DynamicPropertyFactory.getInstance();
        ConfigurationManager.getConfigInstance().addConfigurationListener(this.configurationListener);
    }

    public void close() {
        ConfigurationManager.getConfigInstance().removeConfigurationListener(this.configurationListener);
    }

    public synchronized void configurationListener(ConfigurationEvent event) {
        if (event.isBeforeUpdate()) {
            return;
        }
        if (this.keyCache == null) {
            this.keyCache = new ConcurrentHashMapEx();
            this.updateCache(new Object(), this.priorityPropertySet);
            this.configObjectMap.forEach((k, v) -> this.updateCache(k, (Collection<PriorityProperty<?>>)v));
        }
        if (event.getPropertyName() != null) {
            this.keyCache.forEach((k, v) -> v.getOrDefault(event.getPropertyName(), Collections.emptyList()).stream().forEach(p -> p.updateFinalValue(false, k)));
            return;
        }
        this.keyCache.forEach((k, v) -> v.values().stream().flatMap(Collection::stream).forEach(p -> p.updateFinalValue(false, k)));
    }

    private void updateCache(Object target, Collection<PriorityProperty<?>> properties) {
        Map targetMap = this.keyCache.computeIfAbsent(target, k -> new HashMap());
        for (PriorityProperty<?> priorityProperty : properties) {
            for (String key : priorityProperty.getPriorityKeys()) {
                targetMap.computeIfAbsent(key, k -> new ArrayList()).add(priorityProperty);
            }
            priorityProperty.updateFinalValue(false, target);
        }
    }

    public Set<PriorityProperty<?>> getPriorityPropertySet() {
        return this.priorityPropertySet;
    }

    public Map<Object, List<PriorityProperty<?>>> getConfigObjectMap() {
        return this.configObjectMap;
    }

    private synchronized void registerPriorityProperty(PriorityProperty<?> property) {
        this.priorityPropertySet.add(property);
        this.keyCache = null;
    }

    private synchronized void registerConfigObject(Object configObject, List<PriorityProperty<?>> properties) {
        this.configObjectMap.put(configObject, properties);
        this.keyCache = null;
    }

    public <T> T createConfigObject(Class<T> cls, Object ... kvs) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        for (int idx = 0; idx < kvs.length; idx += 2) {
            parameters.put(kvs[idx].toString(), kvs[idx + 1]);
        }
        return this.createConfigObject(cls, parameters);
    }

    public <T> T createConfigObject(Class<T> cls, Map<String, Object> parameters) {
        ConfigObjectFactory factory = new ConfigObjectFactory();
        T configObject = factory.create(this, cls, parameters);
        this.registerConfigObject(configObject, factory.getPriorityProperties());
        return configObject;
    }

    public <T> PriorityProperty<T> newPriorityProperty(Type cls, T invalidValue, T defaultValue, String ... priorityKeys) {
        return new PriorityProperty<T>(cls, invalidValue, defaultValue, priorityKeys);
    }

    public <T> PriorityProperty<T> createPriorityProperty(Type cls, T invalidValue, T defaultValue, String ... priorityKeys) {
        PriorityProperty<T> priorityProperty = new PriorityProperty<T>(cls, invalidValue, defaultValue, priorityKeys);
        this.registerPriorityProperty(priorityProperty);
        return priorityProperty;
    }
}

