/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.transport.rest.servlet;

import java.util.Arrays;
import java.util.LinkedHashSet;
import javax.servlet.ServletContext;
import org.apache.commons.lang3.StringUtils;
import org.apache.servicecomb.foundation.common.utils.BeanUtils;
import org.apache.servicecomb.transport.rest.servlet.ServletUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.web.context.support.XmlWebApplicationContext;

public class CseXmlWebApplicationContext
extends XmlWebApplicationContext {
    private static final Logger LOGGER = LoggerFactory.getLogger(CseXmlWebApplicationContext.class);
    static final String KEY_LOCATION = "contextConfigLocation";
    private String[] defaultBeanResource = BeanUtils.DEFAULT_BEAN_RESOURCE;

    public CseXmlWebApplicationContext() {
    }

    public CseXmlWebApplicationContext(ServletContext servletContext) {
        this.setServletContext(servletContext);
    }

    public void setDefaultBeanResource(String[] defaultBeanResource) {
        if (defaultBeanResource == null) {
            return;
        }
        this.defaultBeanResource = defaultBeanResource;
    }

    protected void invokeBeanFactoryPostProcessors(ConfigurableListableBeanFactory beanFactory) {
        super.invokeBeanFactoryPostProcessors(beanFactory);
        ServletUtils.init(this.getServletContext());
    }

    public String[] getConfigLocations() {
        String contextConfigLocation = this.getServletContext().getInitParameter(KEY_LOCATION);
        Object[] locationArray = this.splitLocations(contextConfigLocation);
        LOGGER.info("init spring context: {}.", (Object)Arrays.toString(locationArray));
        return locationArray;
    }

    private String[] splitLocations(String locations) {
        LinkedHashSet locationSet = new LinkedHashSet();
        BeanUtils.addBeanLocation(locationSet, (String[])BeanUtils.DEFAULT_BEAN_RESOURCE);
        BeanUtils.addBeanLocation(locationSet, (String[])this.defaultBeanResource);
        if (StringUtils.isNotEmpty((CharSequence)locations)) {
            for (String location : locations.split("[,\n]")) {
                BeanUtils.addBeanLocation(locationSet, (String)location);
            }
        }
        return locationSet.toArray(new String[locationSet.size()]);
    }
}

