/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.localregistry;

import com.google.common.annotations.VisibleForTesting;
import io.swagger.models.Swagger;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.servicecomb.config.YAMLUtil;
import org.apache.servicecomb.foundation.common.utils.BeanUtils;
import org.apache.servicecomb.foundation.common.utils.JvmUtils;
import org.apache.servicecomb.localregistry.RegistryBean;
import org.apache.servicecomb.registry.api.registry.FindInstancesResponse;
import org.apache.servicecomb.registry.api.registry.Microservice;
import org.apache.servicecomb.registry.api.registry.MicroserviceFactory;
import org.apache.servicecomb.registry.api.registry.MicroserviceInstance;
import org.apache.servicecomb.registry.api.registry.MicroserviceInstances;
import org.apache.servicecomb.swagger.SwaggerUtils;
import org.apache.servicecomb.swagger.generator.SwaggerGenerator;

public class LocalRegistryStore {
    private static final String REGISTRY_FILE_NAME = "registry.yaml";
    public static final LocalRegistryStore INSTANCE = new LocalRegistryStore();
    private Microservice selfMicroservice;
    private MicroserviceInstance selfMicroserviceInstance;
    private Map<String, Microservice> microserviceMap = new ConcurrentHashMap<String, Microservice>();
    private Map<String, Map<String, MicroserviceInstance>> microserviceInstanceMap = new ConcurrentHashMap<String, Map<String, MicroserviceInstance>>();

    @VisibleForTesting
    public void initSelfWithMocked(Microservice microservice, MicroserviceInstance microserviceInstance) {
        this.selfMicroservice = microservice;
        this.selfMicroserviceInstance = microserviceInstance;
    }

    public void init() {
        MicroserviceFactory microserviceFactory = new MicroserviceFactory();
        this.selfMicroservice = microserviceFactory.create();
        this.selfMicroserviceInstance = this.selfMicroservice.getInstance();
        this.microserviceMap.clear();
        this.microserviceInstanceMap.clear();
    }

    public void run() {
        this.selfMicroservice.setServiceId("[local]-[" + this.selfMicroservice.getAppId() + "]-[" + this.selfMicroservice.getServiceName() + "]");
        this.selfMicroserviceInstance.setInstanceId(this.selfMicroservice.getServiceId());
        this.selfMicroserviceInstance.setServiceId(this.selfMicroservice.getServiceId());
        List<RegistryBean> beans = this.loadYamlBeans();
        BeanUtils.getBeansOfType(RegistryBean.class).entrySet().forEach(entry -> beans.add((RegistryBean)entry.getValue()));
        this.initRegistryFromBeans(beans);
        this.addSelf();
    }

    private void addSelf() {
        this.microserviceMap.put(this.selfMicroservice.getServiceId(), this.selfMicroservice);
        HashMap<String, MicroserviceInstance> selfInstanceMap = new HashMap<String, MicroserviceInstance>(1);
        selfInstanceMap.put(this.selfMicroserviceInstance.getInstanceId(), this.selfMicroserviceInstance);
        this.microserviceInstanceMap.put(this.selfMicroservice.getServiceId(), selfInstanceMap);
    }

    public Microservice getSelfMicroservice() {
        return this.selfMicroservice;
    }

    public MicroserviceInstance getSelfMicroserviceInstance() {
        return this.selfMicroserviceInstance;
    }

    private List<RegistryBean> loadYamlBeans() {
        ArrayList<RegistryBean> beans = new ArrayList<RegistryBean>();
        try {
            ClassLoader loader = JvmUtils.findClassLoader();
            Enumeration<URL> urls = loader.getResources(REGISTRY_FILE_NAME);
            while (urls.hasMoreElements()) {
                URL url = urls.nextElement();
                InputStream is = url.openStream();
                Throwable throwable = null;
                try {
                    if (is == null) continue;
                    beans.addAll(this.initFromData(is));
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (is == null) continue;
                    if (throwable != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    is.close();
                }
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        return beans;
    }

    private List<RegistryBean> initFromData(InputStream is) {
        Map data = YAMLUtil.yaml2Properties((InputStream)is);
        return this.initFromData(data);
    }

    private List<RegistryBean> initFromData(Map<String, Object> data) {
        ArrayList<RegistryBean> beans = new ArrayList<RegistryBean>();
        for (Map.Entry<String, Object> entry : data.entrySet()) {
            String name = entry.getKey();
            List serviceConfigs = (List)entry.getValue();
            for (Map serviceConfig : serviceConfigs) {
                beans.add(RegistryBean.buildFromYamlModel(name, serviceConfig));
            }
        }
        return beans;
    }

    private void initRegistryFromBeans(List<RegistryBean> beans) {
        beans.forEach(bean -> {
            Microservice microservice = new Microservice();
            microservice.setAppId(bean.getAppId());
            microservice.setServiceName(bean.getServiceName());
            microservice.setVersion(bean.getVersion());
            microservice.setServiceId(bean.getId());
            microservice.setSchemas(bean.getSchemaIds());
            this.addSchemaInterface((RegistryBean)bean, microservice);
            this.microserviceMap.put(microservice.getServiceId(), microservice);
            this.addInstances((RegistryBean)bean, microservice);
        });
    }

    private void addSchemaInterface(RegistryBean bean, Microservice microservice) {
        bean.getSchemaInterfaces().forEach((k, v) -> {
            SwaggerGenerator generator = SwaggerGenerator.create((Class)v);
            microservice.getSchemaMap().put(k, SwaggerUtils.swaggerToString((Swagger)generator.generate()));
        });
    }

    private void addInstances(RegistryBean bean, Microservice microservice) {
        ConcurrentHashMap<String, MicroserviceInstance> instanceMap = new ConcurrentHashMap<String, MicroserviceInstance>();
        this.microserviceInstanceMap.put(microservice.getServiceId(), instanceMap);
        for (RegistryBean.Instance item : bean.getInstances().getInstances()) {
            MicroserviceInstance instance = new MicroserviceInstance();
            instance.setInstanceId(UUID.randomUUID().toString());
            instance.setEndpoints(item.getEndpoints());
            instance.setServiceId(microservice.getServiceId());
            instanceMap.put(instance.getInstanceId(), instance);
        }
    }

    public Microservice getMicroservice(String microserviceId) {
        return this.microserviceMap.get(microserviceId);
    }

    public List<Microservice> getAllMicroservices() {
        return this.microserviceMap.values().stream().collect(Collectors.toList());
    }

    public String getSchema(String microserviceId, String schemaId) {
        Microservice microservice = this.microserviceMap.get(microserviceId);
        if (microservice == null) {
            return null;
        }
        return (String)this.microserviceMap.get(microserviceId).getSchemaMap().get(schemaId);
    }

    public MicroserviceInstance findMicroserviceInstance(String serviceId, String instanceId) {
        Map<String, MicroserviceInstance> microserviceInstance = this.microserviceInstanceMap.get(serviceId);
        if (microserviceInstance == null) {
            return null;
        }
        return this.microserviceInstanceMap.get(serviceId).get(instanceId);
    }

    public MicroserviceInstances findServiceInstances(String appId, String serviceName, String versionRule) {
        MicroserviceInstances microserviceInstances = new MicroserviceInstances();
        FindInstancesResponse findInstancesResponse = new FindInstancesResponse();
        ArrayList instances = new ArrayList();
        Collectors.toList();
        this.microserviceInstanceMap.values().forEach(allInstances -> allInstances.values().stream().filter(aInstance -> {
            Microservice service = this.microserviceMap.get(aInstance.getServiceId());
            return service.getAppId().equals(appId) && service.getServiceName().equals(serviceName);
        }).forEach(item -> instances.add(item)));
        if (instances.isEmpty()) {
            microserviceInstances.setMicroserviceNotExist(true);
        } else {
            findInstancesResponse.setInstances(instances);
            microserviceInstances.setMicroserviceNotExist(false);
            microserviceInstances.setInstancesResponse(findInstancesResponse);
        }
        return microserviceInstances;
    }
}

