/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.governance.handler;

import io.github.resilience4j.ratelimiter.RateLimiter;
import io.github.resilience4j.ratelimiter.RateLimiterConfig;
import io.github.resilience4j.ratelimiter.RateLimiterRegistry;
import java.time.Duration;
import org.apache.servicecomb.governance.handler.AbstractGovernanceHandler;
import org.apache.servicecomb.governance.marker.GovernanceRequest;
import org.apache.servicecomb.governance.policy.RateLimitingPolicy;
import org.apache.servicecomb.governance.properties.RateLimitProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RateLimitingHandler
extends AbstractGovernanceHandler<RateLimiter, RateLimitingPolicy> {
    private static final Logger LOGGER = LoggerFactory.getLogger(RateLimitingHandler.class);
    @Autowired
    private RateLimitProperties rateLimitProperties;

    @Override
    protected String createKey(RateLimitingPolicy policy) {
        return "servicecomb.rateLimiting." + policy.getName();
    }

    @Override
    public RateLimitingPolicy matchPolicy(GovernanceRequest governanceRequest) {
        return (RateLimitingPolicy)this.matchersManager.match(governanceRequest, this.rateLimitProperties.getParsedEntity());
    }

    @Override
    protected RateLimiter createProcessor(RateLimitingPolicy policy) {
        return this.getRateLimiter(policy);
    }

    private RateLimiter getRateLimiter(RateLimitingPolicy policy) {
        LOGGER.info("applying new policy: {}", (Object)policy.toString());
        RateLimiterConfig config = RateLimiterConfig.custom().limitForPeriod(policy.getRate()).limitRefreshPeriod(Duration.ofMillis(policy.getLimitRefreshPeriod())).timeoutDuration(Duration.ofMillis(policy.getTimeoutDuration())).build();
        RateLimiterRegistry rateLimiterRegistry = RateLimiterRegistry.of((RateLimiterConfig)config);
        return rateLimiterRegistry.rateLimiter(policy.getName());
    }
}

