/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.governance.handler;

import io.github.resilience4j.bulkhead.Bulkhead;
import io.github.resilience4j.bulkhead.BulkheadConfig;
import io.github.resilience4j.bulkhead.BulkheadRegistry;
import java.time.Duration;
import org.apache.servicecomb.governance.handler.AbstractGovernanceHandler;
import org.apache.servicecomb.governance.marker.GovernanceRequest;
import org.apache.servicecomb.governance.policy.BulkheadPolicy;
import org.apache.servicecomb.governance.properties.BulkheadProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class BulkheadHandler
extends AbstractGovernanceHandler<Bulkhead, BulkheadPolicy> {
    private static final Logger LOGGER = LoggerFactory.getLogger(BulkheadHandler.class);
    @Autowired
    private BulkheadProperties bulkheadProperties;

    @Override
    protected String createKey(BulkheadPolicy policy) {
        return "servicecomb.bulkhead." + policy.getName();
    }

    @Override
    public BulkheadPolicy matchPolicy(GovernanceRequest governanceRequest) {
        return (BulkheadPolicy)this.matchersManager.match(governanceRequest, this.bulkheadProperties.getParsedEntity());
    }

    @Override
    protected Bulkhead createProcessor(BulkheadPolicy policy) {
        return this.getBulkhead(policy);
    }

    private Bulkhead getBulkhead(BulkheadPolicy policy) {
        LOGGER.info("applying new policy: {}", (Object)policy.toString());
        BulkheadConfig config = BulkheadConfig.custom().maxConcurrentCalls(policy.getMaxConcurrentCalls()).maxWaitDuration(Duration.ofMillis(policy.getMaxWaitDuration())).build();
        BulkheadRegistry registry = BulkheadRegistry.of((BulkheadConfig)config);
        return registry.bulkhead(policy.getName());
    }
}

