/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.core.handler;

import com.netflix.config.DynamicPropertyFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.servicecomb.core.Handler;
import org.apache.servicecomb.core.handler.config.Config;
import org.apache.servicecomb.foundation.common.AbstractObjectManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public abstract class AbstractHandlerManager
extends AbstractObjectManager<String, String, List<Handler>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractHandlerManager.class);
    private String defaultChainDef;
    private Config config;

    protected abstract String getName();

    protected abstract Handler getLastHandler();

    protected abstract String getInnerDefaultChainDef();

    private void loadDefaultChainDef() {
        String key = "servicecomb.handler.chain." + this.getName() + ".default";
        this.defaultChainDef = DynamicPropertyFactory.getInstance().getStringProperty(key, this.getInnerDefaultChainDef()).get();
    }

    private List<Class<Handler>> convertToChainClass(String chainDef) {
        ArrayList<Class<Handler>> result = new ArrayList<Class<Handler>>();
        if (StringUtils.isEmpty((Object)chainDef)) {
            return result;
        }
        String[] handlerIds = chainDef.split(",");
        Map<String, Class<Handler>> handlerMaps = this.config.getHandlerClassMap();
        for (String handlerId : handlerIds) {
            if (handlerId != null) {
                handlerId = handlerId.trim();
            }
            if (StringUtils.isEmpty((Object)handlerId)) continue;
            Class<Handler> cls = handlerMaps.get(handlerId);
            if (cls == null) {
                throw new Error("can not find handler :" + handlerId);
            }
            result.add(cls);
        }
        return result;
    }

    public void init(Config config) {
        this.config = config;
        this.loadDefaultChainDef();
    }

    private List<Handler> createHandlerChain(String chainDef) {
        List<Class<Handler>> chainClasses = this.convertToChainClass(chainDef);
        ArrayList<Handler> handlerList = new ArrayList<Handler>();
        for (Class<Handler> cls : chainClasses) {
            try {
                handlerList.add(cls.newInstance());
            }
            catch (Exception e) {
                throw new Error(e);
            }
        }
        handlerList.add(this.getLastHandler());
        return handlerList;
    }

    protected String getKey(String microserviceName) {
        return microserviceName;
    }

    protected List<Handler> create(String microserviceName) {
        String handlerChainKey = "servicecomb.handler.chain." + this.getName() + ".service." + microserviceName;
        String chainDef = DynamicPropertyFactory.getInstance().getStringProperty(handlerChainKey, this.defaultChainDef).get();
        LOGGER.info("get handler chain for [{}]: [{}]", (Object)handlerChainKey, (Object)chainDef);
        return this.createHandlerChain(chainDef);
    }
}

