/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.core.definition;

import io.swagger.models.Swagger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.servicecomb.core.Handler;
import org.apache.servicecomb.core.SCBEngine;
import org.apache.servicecomb.core.definition.MicroserviceConfig;
import org.apache.servicecomb.core.definition.MicroserviceVersionsMeta;
import org.apache.servicecomb.core.definition.OperationMeta;
import org.apache.servicecomb.core.definition.SchemaMeta;
import org.apache.servicecomb.core.filter.FilterNode;
import org.apache.servicecomb.foundation.common.VendorExtensions;
import org.apache.servicecomb.registry.definition.MicroserviceNameParser;
import org.apache.servicecomb.swagger.SwaggerUtils;

public class MicroserviceMeta {
    private final SCBEngine scbEngine;
    private MicroserviceVersionsMeta microserviceVersionsMeta;
    private String appId;
    private String shortName;
    private String microserviceName;
    private Map<String, SchemaMeta> schemaMetas = new HashMap<String, SchemaMeta>();
    private Map<Class<?>, List<SchemaMeta>> intfSchemaMetas = new HashMap();
    private Map<String, OperationMeta> operationMetas = new HashMap<String, OperationMeta>();
    private boolean consumer;
    private List<Handler> handlerChain = Collections.singletonList((invocation, ar) -> ar.success(null));
    private FilterNode filterChain = FilterNode.EMPTY;
    private Handler providerQpsFlowControlHandler;
    private boolean providerQpsFlowControlHandlerSearched;
    private VendorExtensions vendorExtensions = new VendorExtensions();

    public MicroserviceMeta(SCBEngine scbEngine, String microserviceName, boolean consumer) {
        this.scbEngine = scbEngine;
        MicroserviceNameParser parser = scbEngine.parseMicroserviceName(microserviceName);
        this.appId = parser.getAppId();
        this.shortName = parser.getShortName();
        this.microserviceName = parser.getMicroserviceName();
        this.consumer = consumer;
    }

    public MicroserviceConfig getMicroserviceConfig() {
        return this.microserviceVersionsMeta.getMicroserviceConfig();
    }

    public MicroserviceVersionsMeta getMicroserviceVersionsMeta() {
        return this.microserviceVersionsMeta;
    }

    public void setMicroserviceVersionsMeta(MicroserviceVersionsMeta microserviceVersionsMeta) {
        this.microserviceVersionsMeta = microserviceVersionsMeta;
    }

    public SCBEngine getScbEngine() {
        return this.scbEngine;
    }

    public boolean isConsumer() {
        return this.consumer;
    }

    public String getMicroserviceName() {
        return this.microserviceName;
    }

    public String getAppId() {
        return this.appId;
    }

    public String getShortName() {
        return this.shortName;
    }

    public SchemaMeta registerSchemaMeta(String schemaId, Swagger swagger) {
        SchemaMeta schemaMeta = new SchemaMeta(this, schemaId, swagger);
        if (this.schemaMetas.putIfAbsent(schemaMeta.getSchemaId(), schemaMeta) != null) {
            throw new IllegalStateException(String.format("failed to register SchemaMeta caused by duplicated schemaId, appId=%s, microserviceName=%s, schemaId=%s.", this.appId, this.microserviceName, schemaMeta.getSchemaId()));
        }
        Class intf = SwaggerUtils.getInterface((Swagger)schemaMeta.getSwagger());
        if (intf != null) {
            this.intfSchemaMetas.computeIfAbsent(intf, k -> Collections.synchronizedList(new ArrayList())).add(schemaMeta);
        }
        schemaMeta.getOperations().values().stream().forEach(operationMeta -> this.operationMetas.put(operationMeta.getMicroserviceQualifiedName(), (OperationMeta)operationMeta));
        return schemaMeta;
    }

    public Map<String, OperationMeta> operationMetas() {
        return this.operationMetas;
    }

    public Collection<OperationMeta> getOperations() {
        return this.operationMetas.values();
    }

    public SchemaMeta ensureFindSchemaMeta(String schemaId) {
        SchemaMeta schemaMeta = this.schemaMetas.get(schemaId);
        if (schemaMeta == null) {
            throw new IllegalStateException(String.format("failed to find SchemaMeta by schemaId, appId=%s, microserviceName=%s, schemaId=%s.", this.appId, this.microserviceName, schemaId));
        }
        return schemaMeta;
    }

    public SchemaMeta findSchemaMeta(String schemaId) {
        return this.schemaMetas.get(schemaId);
    }

    public SchemaMeta findSchemaMeta(Class<?> schemaIntf) {
        List<SchemaMeta> schemaList = this.intfSchemaMetas.get(schemaIntf);
        if (schemaList == null) {
            return null;
        }
        if (schemaList.size() > 1) {
            throw new IllegalStateException(String.format("failed to find SchemaMeta by interface cause there are multiple SchemaMeta relate to the interface, please use schemaId to choose a SchemaMeta, appId=%s, microserviceName=%s, interface=%s.", this.appId, this.microserviceName, schemaIntf.getName()));
        }
        return schemaList.get(0);
    }

    public Map<String, SchemaMeta> getSchemaMetas() {
        return this.schemaMetas;
    }

    public void putExtData(String key, Object data) {
        this.vendorExtensions.put((Object)key, data);
    }

    public <T> T getExtData(String key) {
        return (T)this.vendorExtensions.get((Object)key);
    }

    public List<Handler> getHandlerChain() {
        return this.handlerChain;
    }

    public void setHandlerChain(List<Handler> handlerChain) {
        this.handlerChain = handlerChain;
    }

    public FilterNode getFilterChain() {
        return this.filterChain;
    }

    public void setFilterChain(FilterNode filterChain) {
        this.filterChain = filterChain;
    }

    @Deprecated
    public Handler getProviderQpsFlowControlHandler() {
        if (this.providerQpsFlowControlHandlerSearched) {
            return this.providerQpsFlowControlHandler;
        }
        for (Handler handler : this.handlerChain) {
            if (!"org.apache.servicecomb.qps.ProviderQpsFlowControlHandler".equals(handler.getClass().getName())) continue;
            this.providerQpsFlowControlHandler = handler;
            break;
        }
        this.providerQpsFlowControlHandlerSearched = true;
        return this.providerQpsFlowControlHandler;
    }
}

