/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.transport.rest.vertx;

import io.netty.handler.codec.http.HttpHeaderValues;
import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.file.FileSystem;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.ext.web.FileUpload;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.BodyHandler;
import io.vertx.ext.web.handler.impl.BodyHandlerImpl;
import io.vertx.ext.web.impl.FileUploadImpl;
import java.io.File;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.ws.rs.core.Response;
import org.apache.servicecomb.swagger.invocation.exception.CommonExceptionData;
import org.apache.servicecomb.swagger.invocation.exception.ExceptionFactory;
import org.apache.servicecomb.swagger.invocation.exception.InvocationException;

public class RestBodyHandler
implements BodyHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(BodyHandlerImpl.class);
    private static final String BODY_HANDLED = "__body-handled";
    private long bodyLimit = -1L;
    private boolean handleFileUploads;
    private String uploadsDir;
    private boolean mergeFormAttributes = true;
    private boolean deleteUploadedFilesOnEnd = false;
    private boolean isPreallocateBodyBuffer = false;
    private static final int DEFAULT_INITIAL_BODY_BUFFER_SIZE = 1024;
    public static final String BYPASS_BODY_HANDLER = "__bypass_body_handler";

    public RestBodyHandler() {
        this(true, "file-uploads");
    }

    public RestBodyHandler(boolean handleFileUploads) {
        this(handleFileUploads, "file-uploads");
    }

    public RestBodyHandler(String uploadDirectory) {
        this(true, uploadDirectory);
    }

    private RestBodyHandler(boolean handleFileUploads, String uploadDirectory) {
        this.handleFileUploads = handleFileUploads;
        this.setUploadsDirectory(uploadDirectory);
    }

    public void handle(RoutingContext context) {
        HttpServerRequest request = context.request();
        if (request.headers().contains(HttpHeaders.UPGRADE, HttpHeaders.WEBSOCKET, true)) {
            context.next();
            return;
        }
        Boolean bypass = (Boolean)context.get(BYPASS_BODY_HANDLER);
        if (Boolean.TRUE.equals(bypass)) {
            context.next();
            return;
        }
        Boolean handled = (Boolean)context.get(BODY_HANDLED);
        if (handled == null || !handled.booleanValue()) {
            long contentLength = this.isPreallocateBodyBuffer ? this.parseContentLengthHeader(request) : -1L;
            BHandler handler = new BHandler(context, contentLength);
            request.handler((Handler)handler);
            request.endHandler(v -> handler.end());
            context.put(BODY_HANDLED, (Object)true);
        } else {
            if (this.mergeFormAttributes && request.isExpectMultipart()) {
                request.params().addAll(request.formAttributes());
            }
            context.next();
        }
    }

    public BodyHandler setHandleFileUploads(boolean handleFileUploads) {
        this.handleFileUploads = handleFileUploads;
        return this;
    }

    public BodyHandler setBodyLimit(long bodyLimit) {
        this.bodyLimit = bodyLimit;
        return this;
    }

    public BodyHandler setUploadsDirectory(String uploadsDirectory) {
        this.uploadsDir = uploadsDirectory;
        return this;
    }

    public BodyHandler setMergeFormAttributes(boolean mergeFormAttributes) {
        this.mergeFormAttributes = mergeFormAttributes;
        return this;
    }

    public BodyHandler setDeleteUploadedFilesOnEnd(boolean deleteUploadedFilesOnEnd) {
        this.deleteUploadedFilesOnEnd = deleteUploadedFilesOnEnd;
        return this;
    }

    public BodyHandler setPreallocateBodyBuffer(boolean isPreallocateBodyBuffer) {
        this.isPreallocateBodyBuffer = isPreallocateBodyBuffer;
        return this;
    }

    private long parseContentLengthHeader(HttpServerRequest request) {
        String contentLength = request.getHeader(HttpHeaders.CONTENT_LENGTH);
        if (contentLength == null || contentLength.isEmpty()) {
            return -1L;
        }
        try {
            long parsedContentLength = Long.parseLong(contentLength);
            return parsedContentLength < 0L ? null : Long.valueOf(parsedContentLength);
        }
        catch (NumberFormatException ex) {
            return -1L;
        }
    }

    private class BHandler
    implements Handler<Buffer> {
        private static final int MAX_PREALLOCATED_BODY_BUFFER_BYTES = 65535;
        private RoutingContext context;
        private Buffer body;
        private boolean failed;
        private AtomicInteger uploadCount = new AtomicInteger();
        AtomicBoolean cleanup = new AtomicBoolean(false);
        private boolean ended;
        private long uploadSize = 0L;
        private final boolean isMultipart;
        private final boolean isUrlEncoded;

        BHandler(RoutingContext context, long contentLength) {
            this.context = context;
            Set fileUploads = context.fileUploads();
            String contentType = context.request().getHeader(HttpHeaders.CONTENT_TYPE);
            if (contentType == null) {
                this.isMultipart = false;
                this.isUrlEncoded = false;
            } else {
                String lowerCaseContentType = contentType.toLowerCase();
                this.isMultipart = lowerCaseContentType.startsWith(HttpHeaderValues.MULTIPART_FORM_DATA.toString());
                this.isUrlEncoded = lowerCaseContentType.startsWith(HttpHeaderValues.APPLICATION_X_WWW_FORM_URLENCODED.toString());
            }
            this.initBodyBuffer(contentLength);
            if (this.isMultipart || this.isUrlEncoded) {
                context.request().setExpectMultipart(true);
                if (RestBodyHandler.this.handleFileUploads) {
                    this.makeUploadDir(context.vertx().fileSystem());
                }
                context.request().uploadHandler(upload -> {
                    long size;
                    if (RestBodyHandler.this.uploadsDir == null) {
                        this.failed = true;
                        CommonExceptionData data = new CommonExceptionData("not support file upload.");
                        context.fail((Throwable)ExceptionFactory.createProducerException((Object)data));
                        return;
                    }
                    if (RestBodyHandler.this.bodyLimit != -1L && upload.isSizeAvailable() && (size = this.uploadSize + upload.size()) > RestBodyHandler.this.bodyLimit) {
                        this.failed = true;
                        context.fail((Throwable)new InvocationException((Response.StatusType)Response.Status.REQUEST_ENTITY_TOO_LARGE, Response.Status.REQUEST_ENTITY_TOO_LARGE.getReasonPhrase()));
                        return;
                    }
                    if (RestBodyHandler.this.handleFileUploads) {
                        this.uploadCount.incrementAndGet();
                        String uploadedFileName = new File(RestBodyHandler.this.uploadsDir, UUID.randomUUID().toString()).getPath();
                        upload.streamToFileSystem(uploadedFileName);
                        FileUploadImpl fileUpload = new FileUploadImpl(uploadedFileName, upload);
                        fileUploads.add(fileUpload);
                        upload.exceptionHandler(t -> {
                            this.deleteFileUploads();
                            context.fail(t);
                        });
                        upload.endHandler(v -> this.uploadEnded());
                    }
                });
            }
            context.request().exceptionHandler(t -> {
                this.deleteFileUploads();
                context.fail(t);
            });
        }

        private void initBodyBuffer(long contentLength) {
            int initialBodyBufferSize = contentLength < 0L ? 1024 : (contentLength > 65535L ? 65535 : (int)contentLength);
            if (RestBodyHandler.this.bodyLimit != -1L) {
                initialBodyBufferSize = (int)Math.min((long)initialBodyBufferSize, RestBodyHandler.this.bodyLimit);
            }
            this.body = Buffer.buffer((int)initialBodyBufferSize);
        }

        private void makeUploadDir(FileSystem fileSystem) {
            if (RestBodyHandler.this.uploadsDir == null) {
                return;
            }
            if (!fileSystem.existsBlocking(RestBodyHandler.this.uploadsDir)) {
                fileSystem.mkdirsBlocking(RestBodyHandler.this.uploadsDir);
            }
        }

        public void handle(Buffer buff) {
            if (this.failed) {
                return;
            }
            this.uploadSize += (long)buff.length();
            if (RestBodyHandler.this.bodyLimit != -1L && this.uploadSize > RestBodyHandler.this.bodyLimit) {
                this.failed = true;
                this.context.fail((Throwable)new InvocationException((Response.StatusType)Response.Status.REQUEST_ENTITY_TOO_LARGE, Response.Status.REQUEST_ENTITY_TOO_LARGE.getReasonPhrase()));
                this.context.vertx().runOnContext(v -> this.deleteFileUploads());
            } else if (!this.isMultipart) {
                this.body.appendBuffer(buff);
            }
        }

        void uploadEnded() {
            int count = this.uploadCount.decrementAndGet();
            if (this.ended && count == 0) {
                this.doEnd();
            }
        }

        void end() {
            this.ended = true;
            if (this.uploadCount.get() == 0) {
                this.doEnd();
            }
        }

        void doEnd() {
            if (this.failed) {
                this.deleteFileUploads();
                return;
            }
            if (RestBodyHandler.this.deleteUploadedFilesOnEnd) {
                this.context.addBodyEndHandler(x -> this.deleteFileUploads());
            }
            HttpServerRequest req = this.context.request();
            if (RestBodyHandler.this.mergeFormAttributes && req.isExpectMultipart()) {
                req.params().addAll(req.formAttributes());
            }
            this.context.setBody(this.body);
            this.context.next();
        }

        private void deleteFileUploads() {
            if (this.cleanup.compareAndSet(false, true) && RestBodyHandler.this.handleFileUploads) {
                for (FileUpload fileUpload : this.context.fileUploads()) {
                    FileSystem fileSystem = this.context.vertx().fileSystem();
                    String uploadedFileName = fileUpload.uploadedFileName();
                    fileSystem.exists(uploadedFileName, existResult -> {
                        if (existResult.failed()) {
                            LOGGER.warn((Object)("Could not detect if uploaded file exists, not deleting: " + uploadedFileName), existResult.cause());
                        } else if (((Boolean)existResult.result()).booleanValue()) {
                            fileSystem.delete(uploadedFileName, deleteResult -> {
                                if (deleteResult.failed()) {
                                    LOGGER.warn((Object)("Delete of uploaded file failed: " + uploadedFileName), deleteResult.cause());
                                }
                            });
                        }
                    });
                }
            }
        }
    }
}

