/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.foundation.ssl;

import com.netflix.config.ConcurrentCompositeConfiguration;
import com.netflix.config.DynamicPropertyFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Properties;

public final class SSLOption {
    public static final SSLOption DEFAULT_OPTION = new SSLOption();
    public static final String DEFAULT_CIPHERS = "TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384,TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256";
    private String engine;
    private String protocols;
    private String ciphers;
    private boolean authPeer;
    private boolean checkCNHost;
    private boolean checkCNWhite;
    private String checkCNWhiteFile;
    private boolean allowRenegociate;
    private String storePath;
    private String trustStore;
    private String trustStoreType;
    private String trustStoreValue;
    private String keyStore;
    private String keyStoreType;
    private String keyStoreValue;
    private String crl;
    private String sslCustomClass;

    public String getEngine() {
        return this.engine;
    }

    public void setEngine(String engine) {
        this.engine = engine;
    }

    public void setProtocols(String protocols) {
        this.protocols = protocols;
    }

    public void setCiphers(String ciphers) {
        this.ciphers = ciphers;
    }

    public void setAuthPeer(boolean authPeer) {
        this.authPeer = authPeer;
    }

    public void setCheckCNHost(boolean checkCNHost) {
        this.checkCNHost = checkCNHost;
    }

    public void setCheckCNWhite(boolean checkCNWhite) {
        this.checkCNWhite = checkCNWhite;
    }

    public void setCheckCNWhiteFile(String checkCNWhiteFile) {
        this.checkCNWhiteFile = checkCNWhiteFile;
    }

    public void setAllowRenegociate(boolean allowRenegociate) {
        this.allowRenegociate = allowRenegociate;
    }

    public void setStorePath(String storePath) {
        this.storePath = storePath;
    }

    public void setTrustStore(String trustStore) {
        this.trustStore = trustStore;
    }

    public void setTrustStoreType(String trustStoreType) {
        this.trustStoreType = trustStoreType;
    }

    public void setTrustStoreValue(String trustStoreValue) {
        this.trustStoreValue = trustStoreValue;
    }

    public void setKeyStore(String keyStore) {
        this.keyStore = keyStore;
    }

    public void setKeyStoreType(String keyStoreType) {
        this.keyStoreType = keyStoreType;
    }

    public void setKeyStoreValue(String keyStoreValue) {
        this.keyStoreValue = keyStoreValue;
    }

    public void setCrl(String crl) {
        this.crl = crl;
    }

    public String getProtocols() {
        return this.protocols;
    }

    public String getCiphers() {
        return this.ciphers;
    }

    public boolean isAuthPeer() {
        return this.authPeer;
    }

    public boolean isCheckCNHost() {
        return this.checkCNHost;
    }

    public boolean isCheckCNWhite() {
        return this.checkCNWhite;
    }

    public String getCheckCNWhiteFile() {
        return this.checkCNWhiteFile;
    }

    public boolean isAllowRenegociate() {
        return this.allowRenegociate;
    }

    public String getStorePath() {
        return this.storePath;
    }

    public String getTrustStore() {
        return this.trustStore;
    }

    public String getTrustStoreType() {
        return this.trustStoreType;
    }

    public String getTrustStoreValue() {
        return this.trustStoreValue;
    }

    public String getKeyStore() {
        return this.keyStore;
    }

    public String getKeyStoreType() {
        return this.keyStoreType;
    }

    public String getKeyStoreValue() {
        return this.keyStoreValue;
    }

    public String getCrl() {
        return this.crl;
    }

    public static SSLOption build(String optionfile) {
        File file = new File(optionfile);
        if (!file.isFile()) {
            throw new IllegalArgumentException("Bad file name.");
        }
        try {
            SSLOption option = new SSLOption();
            option.load(file.getCanonicalPath());
            return option;
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Bad file name.");
        }
    }

    public static SSLOption build(InputStream inputStream) {
        SSLOption option = new SSLOption();
        option.load(inputStream);
        return option;
    }

    private static String listToString(Object[] lists) {
        StringBuilder sb = new StringBuilder();
        sb.append(lists[0]);
        for (int i = 1; i < lists.length; ++i) {
            sb.append(",");
            sb.append(lists[i]);
        }
        return sb.toString();
    }

    public static String getStringProperty(ConcurrentCompositeConfiguration configSource, String defaultValue, String ... keys) {
        String property = null;
        for (String key : keys) {
            Object v;
            property = configSource != null ? (List.class.isInstance(v = configSource.getProperty(key)) ? SSLOption.listToString(((List)v).toArray()) : (String)configSource.getProperty(key)) : DynamicPropertyFactory.getInstance().getStringProperty(key, null).get();
            if (property != null) break;
        }
        if (property != null) {
            return property;
        }
        return defaultValue;
    }

    private static boolean getBooleanProperty(ConcurrentCompositeConfiguration configSource, boolean defaultValue, String ... keys) {
        String property = null;
        for (String key : keys) {
            if (configSource != null) {
                if (configSource.getProperty(key) != null) {
                    return configSource.getBoolean(key);
                }
            } else {
                property = DynamicPropertyFactory.getInstance().getStringProperty(key, null).get();
            }
            if (property != null) break;
        }
        if (property != null) {
            return Boolean.parseBoolean(property);
        }
        return defaultValue;
    }

    public static SSLOption buildFromYaml(String tag, ConcurrentCompositeConfiguration configSource) {
        SSLOption option = new SSLOption();
        option.engine = SSLOption.getStringProperty(configSource, DEFAULT_OPTION.getEngine(), "ssl." + tag + ".engine", "ssl.engine");
        option.protocols = SSLOption.getStringProperty(configSource, DEFAULT_OPTION.getProtocols(), "ssl." + tag + ".protocols", "ssl.protocols");
        option.ciphers = SSLOption.getStringProperty(configSource, DEFAULT_OPTION.getCiphers(), "ssl." + tag + ".ciphers", "ssl.ciphers");
        option.authPeer = SSLOption.getBooleanProperty(configSource, DEFAULT_OPTION.isAuthPeer(), "ssl." + tag + ".authPeer", "ssl.authPeer");
        option.checkCNHost = SSLOption.getBooleanProperty(configSource, DEFAULT_OPTION.isCheckCNHost(), "ssl." + tag + ".checkCN.host", "ssl.checkCN.host");
        option.checkCNWhite = SSLOption.getBooleanProperty(configSource, DEFAULT_OPTION.isCheckCNWhite(), "ssl." + tag + ".checkCN.white", "ssl.checkCN.white");
        option.checkCNWhiteFile = SSLOption.getStringProperty(configSource, DEFAULT_OPTION.getCiphers(), "ssl." + tag + ".checkCN.white.file", "ssl.checkCN.white.file");
        option.allowRenegociate = SSLOption.getBooleanProperty(configSource, DEFAULT_OPTION.isAllowRenegociate(), "ssl." + tag + ".allowRenegociate", "ssl.allowRenegociate");
        option.storePath = SSLOption.getStringProperty(configSource, DEFAULT_OPTION.getStorePath(), "ssl." + tag + ".storePath", "ssl.storePath");
        option.trustStore = SSLOption.getStringProperty(configSource, DEFAULT_OPTION.getTrustStore(), "ssl." + tag + ".trustStore", "ssl.trustStore");
        option.trustStoreType = SSLOption.getStringProperty(configSource, DEFAULT_OPTION.getTrustStoreType(), "ssl." + tag + ".trustStoreType", "ssl.trustStoreType");
        option.trustStoreValue = SSLOption.getStringProperty(configSource, DEFAULT_OPTION.getTrustStoreValue(), "ssl." + tag + ".trustStoreValue", "ssl.trustStoreValue");
        option.keyStore = SSLOption.getStringProperty(configSource, DEFAULT_OPTION.getKeyStore(), "ssl." + tag + ".keyStore", "ssl.keyStore");
        option.keyStoreType = SSLOption.getStringProperty(configSource, DEFAULT_OPTION.getKeyStoreType(), "ssl." + tag + ".keyStoreType", "ssl.keyStoreType");
        option.keyStoreValue = SSLOption.getStringProperty(configSource, DEFAULT_OPTION.getKeyStoreValue(), "ssl." + tag + ".keyStoreValue", "ssl.keyStoreValue");
        option.crl = SSLOption.getStringProperty(configSource, DEFAULT_OPTION.getCrl(), "ssl." + tag + ".crl", "ssl.crl");
        option.sslCustomClass = SSLOption.getStringProperty(configSource, null, "ssl." + tag + ".sslCustomClass", "ssl.sslCustomClass");
        return option;
    }

    public static SSLOption buildFromYaml(String tag) {
        return SSLOption.buildFromYaml(tag, null);
    }

    private void fromProperty(Properties props) {
        this.protocols = this.propString(props, "ssl.protocols");
        this.ciphers = this.propString(props, "ssl.ciphers");
        this.authPeer = this.propBoolean(props, "ssl.authPeer");
        this.checkCNHost = this.propBoolean(props, "ssl.checkCN.host");
        this.checkCNWhite = this.propBoolean(props, "ssl.checkCN.white");
        this.checkCNWhiteFile = this.propString(props, "ssl.checkCN.white.file");
        this.allowRenegociate = this.propBoolean(props, "ssl.allowRenegociate");
        this.storePath = this.propString(props, "ssl.storePath");
        this.trustStore = this.propString(props, "ssl.trustStore");
        this.trustStoreType = this.propString(props, "ssl.trustStoreType");
        this.trustStoreValue = this.propString(props, "ssl.trustStoreValue");
        this.keyStore = this.propString(props, "ssl.keyStore");
        this.keyStoreType = this.propString(props, "ssl.keyStoreType");
        this.keyStoreValue = this.propString(props, "ssl.keyStoreValue");
        this.crl = this.propString(props, "ssl.crl");
        this.sslCustomClass = props.getProperty("ssl.sslCustomClass");
    }

    private String propString(Properties props, String key) {
        String s = props.getProperty(key);
        if (s == null) {
            throw new IllegalArgumentException("No key :" + key);
        }
        return s;
    }

    private boolean propBoolean(Properties props, String key) {
        String s = props.getProperty(key);
        if (s == null) {
            throw new IllegalArgumentException("No key :" + key);
        }
        return Boolean.parseBoolean(s);
    }

    private void load(InputStream inputStream) {
        Properties props = new Properties();
        InputStreamReader reader = null;
        try {
            reader = new InputStreamReader(inputStream, Charset.forName("UTF-8"));
            props.load(reader);
            this.fromProperty(props);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Can not read ssl client config file");
        }
        finally {
            if (reader != null) {
                try {
                    ((Reader)reader).close();
                }
                catch (IOException e) {
                    this.ignore();
                }
            }
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    this.ignore();
                }
            }
        }
    }

    private void load(String path) {
        try {
            this.load(new FileInputStream(path));
        }
        catch (FileNotFoundException e) {
            throw new IllegalArgumentException("Can not read ssl client config file: " + path);
        }
    }

    private void ignore() {
    }

    public String getSslCustomClass() {
        return this.sslCustomClass;
    }

    public void setSslCustomClass(String sslCustomClass) {
        this.sslCustomClass = sslCustomClass;
    }

    static {
        DEFAULT_OPTION.setEngine("jdk");
        DEFAULT_OPTION.setProtocols("TLSv1.2");
        DEFAULT_OPTION.setCiphers(DEFAULT_CIPHERS);
        DEFAULT_OPTION.setAuthPeer(false);
        DEFAULT_OPTION.setCheckCNHost(false);
        DEFAULT_OPTION.setCheckCNWhite(false);
        DEFAULT_OPTION.setCheckCNWhiteFile("white.list");
        DEFAULT_OPTION.setAllowRenegociate(true);
        DEFAULT_OPTION.setStorePath("internal");
        DEFAULT_OPTION.setTrustStore("trust.jks");
        DEFAULT_OPTION.setTrustStoreType("JKS");
        DEFAULT_OPTION.setTrustStoreValue("trustStoreValue");
        DEFAULT_OPTION.setKeyStore("server.p12");
        DEFAULT_OPTION.setKeyStoreType("PKCS12");
        DEFAULT_OPTION.setKeyStoreValue("keyStoreValue");
        DEFAULT_OPTION.setCrl("revoke.crl");
    }
}

