/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.transport.rest.client;

import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import org.apache.servicecomb.core.Invocation;
import org.apache.servicecomb.core.filter.ConsumerFilter;
import org.apache.servicecomb.core.filter.FilterNode;
import org.apache.servicecomb.swagger.invocation.Response;
import org.apache.servicecomb.swagger.invocation.context.TransportContext;
import org.apache.servicecomb.transport.rest.client.RestClientDecoder;
import org.apache.servicecomb.transport.rest.client.RestClientEncoder;
import org.apache.servicecomb.transport.rest.client.RestClientTransportContext;
import org.apache.servicecomb.transport.rest.client.RestClientTransportContextFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RestClientCodecFilter
implements ConsumerFilter {
    public static final String NAME = "rest-client-codec";
    protected RestClientTransportContextFactory transportContextFactory;
    protected RestClientEncoder encoder;
    protected RestClientDecoder decoder;

    @Nonnull
    public String getName() {
        return NAME;
    }

    @Autowired
    public RestClientCodecFilter setTransportContextFactory(RestClientTransportContextFactory transportContextFactory) {
        this.transportContextFactory = transportContextFactory;
        return this;
    }

    @Autowired
    public RestClientCodecFilter setEncoder(RestClientEncoder encoder) {
        this.encoder = encoder;
        return this;
    }

    @Autowired
    public RestClientCodecFilter setDecoder(RestClientDecoder decoder) {
        this.decoder = decoder;
        return this;
    }

    public CompletableFuture<Response> onFilter(Invocation invocation, FilterNode nextNode) {
        this.startClientFiltersRequest(invocation);
        return ((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)CompletableFuture.completedFuture(null).thenAccept(v -> this.prepareTransportContext(invocation))).thenAccept(v -> this.encoder.encode(invocation))).thenCompose(v -> nextNode.onFilter(invocation))).thenApply(response -> this.decoder.decode(invocation, (Response)response))).whenComplete((response, throwable) -> this.finishClientFiltersResponse(invocation));
    }

    protected void startClientFiltersRequest(Invocation invocation) {
        invocation.getInvocationStageTrace().startClientFiltersRequest();
    }

    protected void prepareTransportContext(Invocation invocation) {
        RestClientTransportContext transportContext = this.transportContextFactory.create(invocation);
        invocation.setTransportContext((TransportContext)transportContext);
    }

    protected void finishClientFiltersResponse(Invocation invocation) {
        invocation.getInvocationStageTrace().finishClientFiltersResponse();
    }
}

