/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.huaweicloud.dashboard.monitor;

import com.google.common.eventbus.Subscribe;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.servicecomb.deployment.Deployment;
import org.apache.servicecomb.deployment.SystemBootstrapInfo;
import org.apache.servicecomb.foundation.common.event.EventManager;
import org.apache.servicecomb.huaweicloud.dashboard.monitor.event.MonitorFailEvent;
import org.apache.servicecomb.registry.api.registry.MicroserviceInstance;
import org.apache.servicecomb.serviceregistry.RegistryUtils;

public class AddressManager {
    private static final String MONITR_SERVICE_NAME = "CseMonitoring";
    private static final String MONITR_APPLICATION = "default";
    private static final String MONITR_VERSION = "latest";
    private Map<String, State> addresses = new LinkedHashMap<String, State>();
    private String currentServer;
    private State discoveryState = new State();

    AddressManager() {
        this.updateAddresses();
        EventManager.register((Object)this);
    }

    public Map<String, State> getAddresses() {
        return this.addresses;
    }

    public void updateAddresses() {
        SystemBootstrapInfo info = Deployment.getSystemBootStrapInfo((String)"DashboardService");
        if (this.addresses.size() > 0) {
            this.addresses.clear();
        }
        if (info != null && info.getAccessURL() != null) {
            info.getAccessURL().forEach(url -> this.addresses.put((String)url, new State()));
        }
    }

    @Subscribe
    public void MonitorFailEvent(MonitorFailEvent event) {
        this.updateAddresses();
    }

    String nextServer() {
        if (this.currentServer == null && this.addresses.size() > 0) {
            this.currentServer = this.addresses.keySet().iterator().next();
        }
        if (this.currentServer == null || this.addresses.get(this.currentServer).isIsolated()) {
            this.currentServer = null;
            if (!this.discoveryState.isIsolated()) {
                this.updateServersFromSC();
                this.discoveryState.setIsolateStatus(true);
            }
            for (Map.Entry<String, State> entry : this.addresses.entrySet()) {
                if (entry.getValue().isIsolated()) continue;
                this.currentServer = entry.getKey();
                break;
            }
        }
        return this.currentServer;
    }

    private void updateServersFromSC() {
        List servers = RegistryUtils.findServiceInstance((String)MONITR_APPLICATION, (String)MONITR_SERVICE_NAME, (String)MONITR_VERSION);
        if (servers != null) {
            for (MicroserviceInstance server : servers) {
                for (String endpoint : server.getEndpoints()) {
                    this.addresses.computeIfAbsent(endpoint, key -> new State());
                }
            }
        }
    }

    void updateStates(String server, boolean failed) {
        this.addresses.get(server).setIsolateStatus(failed);
    }

    static class State {
        static final long MAX_TIME = 300000L;
        static final int MIN_FAILED = 3;
        private long failedCount = 0L;
        private long time;

        State() {
        }

        public long getTime() {
            return this.time;
        }

        public void setTime(long time) {
            this.time = time;
        }

        boolean isIsolated() {
            if (this.failedCount < 3L) {
                return false;
            }
            if (System.currentTimeMillis() - this.time > 300000L) {
                this.time = System.currentTimeMillis();
                return false;
            }
            return true;
        }

        void setIsolateStatus(boolean isFailed) {
            if (isFailed) {
                if (this.failedCount == 0L) {
                    this.time = System.currentTimeMillis();
                }
                ++this.failedCount;
            } else {
                this.failedCount = 0L;
            }
        }
    }
}

