/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.config.center.client;

import com.google.common.eventbus.EventBus;
import java.util.Collections;
import java.util.Map;
import org.apache.servicecomb.config.center.client.ConfigCenterClient;
import org.apache.servicecomb.config.center.client.model.QueryConfigurationsRequest;
import org.apache.servicecomb.config.center.client.model.QueryConfigurationsResponse;
import org.apache.servicecomb.config.common.ConfigurationChangedEvent;
import org.apache.servicecomb.http.client.task.AbstractTask;
import org.apache.servicecomb.http.client.task.Task;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigCenterManager
extends AbstractTask {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigCenterManager.class);
    private static final long POLL_INTERVAL = 15000L;
    private ConfigCenterClient configCenterClient;
    private final EventBus eventBus;
    private QueryConfigurationsRequest queryConfigurationsRequest;
    private Map<String, Object> lastConfiguration;

    public ConfigCenterManager(ConfigCenterClient configCenterClient, EventBus eventBus) {
        this(configCenterClient, eventBus, Collections.emptyMap());
    }

    public ConfigCenterManager(ConfigCenterClient configCenterClient, EventBus eventBus, Map<String, Object> lastConfiguration) {
        super("config-center-configuration-task");
        this.configCenterClient = configCenterClient;
        this.eventBus = eventBus;
        this.lastConfiguration = lastConfiguration;
    }

    public void setQueryConfigurationsRequest(QueryConfigurationsRequest queryConfigurationsRequest) {
        this.queryConfigurationsRequest = queryConfigurationsRequest;
    }

    public void startConfigCenterManager() {
        this.startTask(new PollConfigurationTask(0));
    }

    class PollConfigurationTask
    implements Task {
        int failCount;

        public PollConfigurationTask(int failCount) {
            this.failCount = failCount;
        }

        public void execute() {
            try {
                QueryConfigurationsResponse response = ConfigCenterManager.this.configCenterClient.queryConfigurations(ConfigCenterManager.this.queryConfigurationsRequest);
                if (response.isChanged()) {
                    ConfigCenterManager.this.queryConfigurationsRequest.setRevision(response.getRevision());
                    ConfigCenterManager.this.eventBus.post((Object)ConfigurationChangedEvent.createIncremental(response.getConfigurations(), (Map)ConfigCenterManager.this.lastConfiguration));
                    ConfigCenterManager.this.lastConfiguration = response.getConfigurations();
                }
                ConfigCenterManager.this.startTask((Task)new AbstractTask.BackOffSleepTask((AbstractTask)ConfigCenterManager.this, 15000L, (Task)new PollConfigurationTask(0)));
            }
            catch (Exception e) {
                LOGGER.error("get configurations from ConfigCenter failed, and will try again.", (Throwable)e);
                ConfigCenterManager.this.startTask((Task)new AbstractTask.BackOffSleepTask((AbstractTask)ConfigCenterManager.this, this.failCount + 1, (Task)new PollConfigurationTask(this.failCount + 1)));
            }
        }
    }
}

