/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.http.client.common;

import java.io.IOException;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.client.HttpClient;
import org.apache.http.util.EntityUtils;
import org.apache.servicecomb.foundation.auth.SignRequest;
import org.apache.servicecomb.http.client.auth.RequestAuthHeaderProvider;
import org.apache.servicecomb.http.client.common.HttpRequest;
import org.apache.servicecomb.http.client.common.HttpResponse;
import org.apache.servicecomb.http.client.common.HttpTransport;

public class HttpTransportImpl
implements HttpTransport {
    private static final String HEADER_CONTENT_TYPE = "Content-Type";
    private static final String HEADER_USER_AGENT = "User-Agent";
    private HttpClient httpClient;
    private Map<String, String> globalHeaders;
    private RequestAuthHeaderProvider requestAuthHeaderProvider;

    public HttpTransportImpl(HttpClient httpClient, RequestAuthHeaderProvider requestAuthHeaderProvider) {
        this.httpClient = httpClient;
        this.requestAuthHeaderProvider = requestAuthHeaderProvider;
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    void setHttpClient(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    @Override
    public HttpResponse get(HttpRequest request) throws IOException {
        request.setMethod("GET");
        return this.doRequest(request);
    }

    @Override
    public HttpResponse post(HttpRequest request) throws IOException {
        request.setMethod("POST");
        return this.doRequest(request);
    }

    @Override
    public HttpResponse put(HttpRequest request) throws IOException {
        request.setMethod("PUT");
        return this.doRequest(request);
    }

    @Override
    public HttpResponse delete(HttpRequest request) throws IOException {
        request.setMethod("DELETE");
        return this.doRequest(request);
    }

    @Override
    public HttpResponse doRequest(HttpRequest httpRequest) throws IOException {
        httpRequest.addHeader(HEADER_CONTENT_TYPE, "application/json");
        httpRequest.addHeader(HEADER_USER_AGENT, "cse-serviceregistry-client/1.0.0");
        if (this.globalHeaders != null) {
            this.globalHeaders.forEach(httpRequest::addHeader);
        }
        httpRequest.getHeaders().putAll(this.requestAuthHeaderProvider.loadAuthHeader(HttpTransportImpl.createSignRequest()));
        org.apache.http.HttpResponse response = this.httpClient.execute(httpRequest.getRealRequest());
        return new HttpResponse(response.getStatusLine().getStatusCode(), response.getStatusLine().getReasonPhrase(), response.getEntity() == null ? null : EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8"), response.getAllHeaders());
    }

    private static SignRequest createSignRequest() {
        return null;
    }

    @Override
    public void addHeaders(Map<String, String> headers) {
        this.globalHeaders = headers;
    }
}

