/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.provider.pojo.definition;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.google.common.reflect.TypeToken;
import java.lang.reflect.Type;
import javax.servlet.http.Part;
import org.apache.servicecomb.core.definition.InvocationRuntimeType;
import org.apache.servicecomb.core.definition.OperationMeta;
import org.apache.servicecomb.core.provider.consumer.ReferenceConfig;
import org.apache.servicecomb.provider.pojo.definition.PojoConsumerMeta;
import org.apache.servicecomb.swagger.engine.SwaggerConsumerOperation;
import org.apache.servicecomb.swagger.generator.SwaggerGeneratorUtils;

public class PojoConsumerOperationMeta {
    private PojoConsumerMeta pojoConsumerMeta;
    private OperationMeta operationMeta;
    private SwaggerConsumerOperation swaggerConsumerOperation;
    private JavaType responseType;
    private InvocationRuntimeType invocationRuntimeType;

    public PojoConsumerOperationMeta(PojoConsumerMeta pojoConsumerMeta, OperationMeta operationMeta, SwaggerConsumerOperation swaggerConsumerOperation) {
        this.pojoConsumerMeta = pojoConsumerMeta;
        this.operationMeta = operationMeta;
        this.swaggerConsumerOperation = swaggerConsumerOperation;
        this.initResponseType();
        this.initRuntimeType();
    }

    private void initRuntimeType() {
        this.invocationRuntimeType = this.operationMeta.buildBaseConsumerRuntimeType();
        this.invocationRuntimeType.setArgumentsMapper(this.swaggerConsumerOperation.getArgumentsMapper());
        this.invocationRuntimeType.setAssociatedClass(this.swaggerConsumerOperation.getConsumerClass());
        this.invocationRuntimeType.setAssociatedMethod(this.swaggerConsumerOperation.getConsumerMethod());
    }

    public PojoConsumerMeta getPojoConsumerMeta() {
        return this.pojoConsumerMeta;
    }

    public OperationMeta getOperationMeta() {
        return this.operationMeta;
    }

    public SwaggerConsumerOperation getSwaggerConsumerOperation() {
        return this.swaggerConsumerOperation;
    }

    public JavaType getResponsesType() {
        return this.responseType;
    }

    public InvocationRuntimeType getInvocationRuntimeType() {
        return this.invocationRuntimeType;
    }

    public ReferenceConfig createReferenceConfig(PojoConsumerOperationMeta consumerOperationMeta) {
        return this.pojoConsumerMeta.getMicroserviceReferenceConfig().createReferenceConfig(consumerOperationMeta.getOperationMeta());
    }

    private void initResponseType() {
        Type intfResponseType = TypeToken.of((Class)this.swaggerConsumerOperation.getConsumerClass()).resolveType(this.swaggerConsumerOperation.getConsumerMethod().getGenericReturnType()).getType();
        if (intfResponseType instanceof Class && Part.class.isAssignableFrom((Class)intfResponseType)) {
            this.responseType = TypeFactory.defaultInstance().constructType(Part.class);
            return;
        }
        if ((intfResponseType = SwaggerGeneratorUtils.findResponseTypeProcessor((Type)intfResponseType).extractResponseType(intfResponseType)) != null) {
            this.responseType = TypeFactory.defaultInstance().constructType(intfResponseType);
        }
    }
}

