/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.core.invocation;

import org.apache.servicecomb.core.Invocation;

public class InvocationStageTrace {
    public static final String PREPARE = "prepare";
    public static final String HANDLERS_REQUEST = "handlers request";
    public static final String HANDLERS_RESPONSE = "handlers response";
    public static final String CLIENT_FILTERS_REQUEST = "client filters request";
    public static final String CONSUMER_SEND_REQUEST = "send request";
    public static final String CONSUMER_GET_CONNECTION = "get connection";
    public static final String CONSUMER_WRITE_TO_BUF = "write to buf";
    public static final String CONSUMER_WAIT_RESPONSE = "wait response";
    public static final String CONSUMER_WAKE_CONSUMER = "wake consumer";
    public static final String CLIENT_FILTERS_RESPONSE = "client filters response";
    public static final String THREAD_POOL_QUEUE = "threadPoolQueue";
    public static final String SERVER_FILTERS_REQUEST = "server filters request";
    public static final String SERVER_FILTERS_RESPONSE = "server filters response";
    public static final String PRODUCER_SEND_RESPONSE = "send response";
    private Invocation invocation;
    private long startCurrentTime;
    private long start;
    private long startHandlersRequest;
    private long startClientFiltersRequest;
    private long startSend;
    private long finishGetConnection;
    private long finishWriteToBuffer;
    private long finishReceiveResponse;
    private long startClientFiltersResponse;
    private long finishClientFiltersResponse;
    private long finishHandlersResponse;
    private long finish;
    private long startSchedule;
    private long startServerFiltersRequest;
    private long finishServerFiltersResponse;
    private long startExecution;
    private long startBusinessMethod;
    private long finishBusiness;

    public InvocationStageTrace(Invocation invocation) {
        this.invocation = invocation;
    }

    public void start(long start) {
        this.startCurrentTime = System.currentTimeMillis();
        this.start = start;
    }

    public long getStart() {
        return this.start;
    }

    public long getStartCurrentTime() {
        return this.startCurrentTime;
    }

    public InvocationStageTrace setStartCurrentTime(long startCurrentTime) {
        this.startCurrentTime = startCurrentTime;
        return this;
    }

    public long getStartHandlersRequest() {
        return this.startHandlersRequest;
    }

    public void startHandlersRequest() {
        this.startHandlersRequest = System.nanoTime();
    }

    public long getStartClientFiltersRequest() {
        return this.startClientFiltersRequest;
    }

    public void startClientFiltersRequest() {
        this.startClientFiltersRequest = System.nanoTime();
    }

    public long getStartSchedule() {
        return this.startSchedule;
    }

    public void startSchedule() {
        this.startSchedule = System.nanoTime();
    }

    public long getStartExecution() {
        return this.startExecution;
    }

    public void startExecution() {
        this.startExecution = System.nanoTime();
    }

    public long getStartSend() {
        return this.startSend;
    }

    public void startSend() {
        this.startSend = System.nanoTime();
    }

    public long getFinishGetConnection() {
        return this.finishGetConnection;
    }

    public void finishGetConnection(long finishGetConnection) {
        this.finishGetConnection = finishGetConnection;
    }

    public long getFinishWriteToBuffer() {
        return this.finishWriteToBuffer;
    }

    public void finishWriteToBuffer(long finishWriteToBuffer) {
        this.finishWriteToBuffer = finishWriteToBuffer;
    }

    public long getFinishReceiveResponse() {
        return this.finishReceiveResponse;
    }

    public void finishReceiveResponse() {
        this.finishReceiveResponse = System.nanoTime();
    }

    public long getStartClientFiltersResponse() {
        return this.startClientFiltersResponse;
    }

    public void startClientFiltersResponse() {
        this.startClientFiltersResponse = System.nanoTime();
    }

    public long getFinishClientFiltersResponse() {
        return this.finishClientFiltersResponse;
    }

    public void finishClientFiltersResponse() {
        this.finishClientFiltersResponse = System.nanoTime();
    }

    public long getFinishHandlersResponse() {
        return this.finishHandlersResponse;
    }

    public void finishHandlersResponse() {
        this.finishHandlersResponse = System.nanoTime();
    }

    public long getStartServerFiltersRequest() {
        return this.startServerFiltersRequest;
    }

    public void startServerFiltersRequest() {
        this.startServerFiltersRequest = System.nanoTime();
    }

    public long getFinishServerFiltersResponse() {
        return this.finishServerFiltersResponse;
    }

    public void finishServerFiltersResponse() {
        this.finishServerFiltersResponse = System.nanoTime();
    }

    public long getStartBusinessMethod() {
        return this.startBusinessMethod;
    }

    public void startBusinessMethod() {
        this.startBusinessMethod = System.nanoTime();
    }

    public long getFinishBusiness() {
        return this.finishBusiness;
    }

    public void finishBusiness() {
        this.finishBusiness = System.nanoTime();
    }

    public long getFinish() {
        return this.finish;
    }

    public void finish() {
        this.finish = System.nanoTime();
    }

    private double calc(long finish, long start) {
        if (finish == 0L || start == 0L) {
            return Double.NaN;
        }
        return finish - start;
    }

    public double calcTotalTime() {
        return this.calc(this.finish, this.start);
    }

    public double calcInvocationPrepareTime() {
        if (this.invocation.isConsumer() && !this.invocation.isEdge()) {
            return this.calc(this.startHandlersRequest, this.start);
        }
        return this.calc(this.startSchedule, this.start);
    }

    public double calcHandlersRequestTime() {
        if (this.invocation.isConsumer()) {
            return this.calc(this.startClientFiltersRequest, this.startHandlersRequest);
        }
        return this.calc(this.startBusinessMethod, this.startHandlersRequest);
    }

    public double calcClientFiltersRequestTime() {
        return this.calc(this.startSend, this.startClientFiltersRequest);
    }

    public double calcServerFiltersRequestTime() {
        return this.calc(this.startHandlersRequest, this.startServerFiltersRequest);
    }

    public double calcSendRequestTime() {
        return this.calc(this.finishWriteToBuffer, this.startSend);
    }

    public double calcGetConnectionTime() {
        return this.calc(this.finishGetConnection, this.startSend);
    }

    public double calcWriteToBufferTime() {
        return this.calc(this.finishWriteToBuffer, this.finishGetConnection);
    }

    public double calcReceiveResponseTime() {
        return this.calc(this.finishReceiveResponse, this.finishWriteToBuffer);
    }

    public double calcWakeConsumer() {
        return this.calc(this.startClientFiltersResponse, this.finishReceiveResponse);
    }

    public double calcClientFiltersResponseTime() {
        return this.calc(this.finishClientFiltersResponse, this.startClientFiltersResponse);
    }

    public double calcServerFiltersResponseTime() {
        return this.calc(this.finishServerFiltersResponse, this.finishHandlersResponse);
    }

    public double calcHandlersResponseTime() {
        if (this.invocation.isConsumer()) {
            return this.calc(this.finishHandlersResponse, this.finishClientFiltersResponse);
        }
        return this.calc(this.finishHandlersResponse, this.finishBusiness);
    }

    public double calcThreadPoolQueueTime() {
        return this.calc(this.startExecution, this.startSchedule);
    }

    public double calcBusinessTime() {
        return this.calc(this.finishBusiness, this.startBusinessMethod);
    }

    public double calcSendResponseTime() {
        return this.calc(this.finish, this.finishServerFiltersResponse);
    }
}

