/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.core.filter.impl;

import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.servicecomb.core.Endpoint;
import org.apache.servicecomb.core.Invocation;
import org.apache.servicecomb.core.exception.Exceptions;
import org.apache.servicecomb.core.filter.Filter;
import org.apache.servicecomb.core.filter.FilterMeta;
import org.apache.servicecomb.core.filter.FilterNode;
import org.apache.servicecomb.core.handler.impl.SimpleLoadBalanceHandler;
import org.apache.servicecomb.core.registry.discovery.EndpointDiscoveryFilter;
import org.apache.servicecomb.foundation.common.concurrent.ConcurrentHashMapEx;
import org.apache.servicecomb.registry.discovery.DiscoveryContext;
import org.apache.servicecomb.registry.discovery.DiscoveryFilter;
import org.apache.servicecomb.registry.discovery.DiscoveryTree;
import org.apache.servicecomb.registry.discovery.DiscoveryTreeNode;
import org.apache.servicecomb.swagger.invocation.InvocationType;
import org.apache.servicecomb.swagger.invocation.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@FilterMeta(name="simple-load-balance", invocationType={InvocationType.CONSUMER}, shareable=false)
public class SimpleLoadBalanceFilter
implements Filter {
    private static final Logger LOGGER = LoggerFactory.getLogger(SimpleLoadBalanceHandler.class);
    private DiscoveryTree discoveryTree = new DiscoveryTree();
    private volatile Map<String, AtomicInteger> indexMap = new ConcurrentHashMapEx();

    public SimpleLoadBalanceFilter() {
        this.discoveryTree.loadFromSPI(DiscoveryFilter.class);
        this.discoveryTree.addFilter((DiscoveryFilter)new EndpointDiscoveryFilter());
        this.discoveryTree.sort();
    }

    @Override
    public CompletableFuture<Response> onFilter(Invocation invocation, FilterNode nextNode) {
        if (invocation.getEndpoint() != null) {
            return nextNode.onFilter(invocation);
        }
        invocation.setEndpoint(this.selectEndpoint(invocation));
        return nextNode.onFilter(invocation);
    }

    public Endpoint selectEndpoint(Invocation invocation) {
        DiscoveryContext context = new DiscoveryContext();
        context.setInputParameters((Object)invocation);
        DiscoveryTreeNode endpointsVersionedCache = this.discoveryTree.discovery(context, invocation.getAppId(), invocation.getMicroserviceName(), invocation.getMicroserviceVersionRule());
        if (endpointsVersionedCache.isEmpty()) {
            String msg = "No available address found.";
            LOGGER.error("{} microserviceName={}, version={}, discoveryGroupName={}", new Object[]{msg, invocation.getMicroserviceName(), invocation.getMicroserviceVersionRule(), endpointsVersionedCache.name()});
            throw Exceptions.consumer("SCB.00000001", msg);
        }
        List endpoints = (List)endpointsVersionedCache.data();
        AtomicInteger index = this.indexMap.computeIfAbsent(endpointsVersionedCache.name(), name -> {
            LOGGER.info("Create loadBalancer for {}.", name);
            return new AtomicInteger();
        });
        LOGGER.debug("invocation {} use discoveryGroup {}.", (Object)invocation.getMicroserviceQualifiedName(), (Object)endpointsVersionedCache.name());
        int idx = Math.abs(index.getAndIncrement());
        return (Endpoint)endpoints.get(idx %= endpoints.size());
    }
}

