/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.core.filter.config;

import com.netflix.config.DynamicPropertyFactory;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.configuration.Configuration;
import org.apache.servicecomb.config.ConfigUtil;
import org.apache.servicecomb.core.filter.config.TransportFilterConfig;
import org.apache.servicecomb.core.filter.config.TransportFiltersConfig;
import org.apache.servicecomb.swagger.invocation.InvocationType;

public class FilterChainsConfig {
    private final List<Object> defaultChain;
    private final Map<String, List<Object>> microserviceChains = new HashMap<String, List<Object>>();
    private final TransportFiltersConfig transportFiltersConfig;

    public FilterChainsConfig(TransportFiltersConfig transportFiltersConfig, InvocationType type) {
        this.transportFiltersConfig = transportFiltersConfig;
        Configuration config = (Configuration)DynamicPropertyFactory.getBackingConfigurationSource();
        String root = "servicecomb.filter-chains." + type.name().toLowerCase(Locale.US);
        this.defaultChain = this.resolve(ConfigUtil.getStringList((Configuration)config, (String)(root + ".default")));
        this.loadMicroserviceChains(config, root + ".policies");
    }

    public List<Object> getDefaultChain() {
        return this.defaultChain;
    }

    public Map<String, List<Object>> getMicroserviceChains() {
        return this.microserviceChains;
    }

    public List<Object> findChain(String microservice) {
        return this.microserviceChains.getOrDefault(microservice, this.defaultChain);
    }

    private void loadMicroserviceChains(Configuration config, String policiesRoot) {
        config.getKeys(policiesRoot).forEachRemaining(qualifiedKey -> {
            String microserviceName = qualifiedKey.substring(policiesRoot.length() + 1);
            List chain = ConfigUtil.getStringList((Configuration)config, (String)qualifiedKey);
            this.microserviceChains.put(microserviceName, this.resolve(chain));
        });
    }

    private List<Object> resolve(List<String> rawChain) {
        return rawChain.stream().map(value -> {
            TransportFilterConfig config = this.transportFiltersConfig.getConfig((String)value);
            return config == null ? value : config;
        }).collect(Collectors.toList());
    }
}

