/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.core.filter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.servicecomb.core.SCBEngine;
import org.apache.servicecomb.core.filter.Filter;
import org.apache.servicecomb.core.filter.FilterMeta;
import org.apache.servicecomb.core.filter.FilterNode;
import org.apache.servicecomb.core.filter.FilterProvider;
import org.apache.servicecomb.core.filter.config.TransportFilterConfig;
import org.apache.servicecomb.core.filter.impl.TransportFilters;
import org.apache.servicecomb.foundation.common.utils.SPIServiceUtils;
import org.apache.servicecomb.swagger.invocation.InvocationType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class FilterManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(FilterManager.class);
    private SCBEngine engine;
    private final List<FilterProvider> providers = new ArrayList<FilterProvider>(SPIServiceUtils.getOrLoadSortedService(FilterProvider.class));
    private final Map<String, Factory> factoryMap = new HashMap<String, Factory>();
    private final List<String> consumerFilters = new ArrayList<String>();
    private final List<String> producerFilters = new ArrayList<String>();

    @Autowired(required=false)
    public void addProviders(Collection<FilterProvider> providers) {
        this.providers.addAll(providers);
    }

    public List<String> getConsumerFilters() {
        return this.consumerFilters;
    }

    public List<String> getProducerFilters() {
        return this.producerFilters;
    }

    public void init(SCBEngine engine) {
        this.engine = engine;
        List filterClasses = this.providers.stream().flatMap(provider -> provider.getFilters().stream()).collect(Collectors.toList());
        for (Class filterClass : filterClasses) {
            FilterMeta meta = filterClass.getAnnotation(FilterMeta.class);
            Factory factory = this.buildFactory(filterClass, meta);
            if (this.factoryMap.put(meta.name(), factory) != null) {
                throw new IllegalStateException(String.format("duplicated filter, name=%s, class=%s", meta.name(), filterClass.getName()));
            }
            if (Arrays.binarySearch(meta.invocationType(), InvocationType.CONSUMER) >= 0) {
                this.consumerFilters.add(meta.name());
            }
            if (Arrays.binarySearch(meta.invocationType(), InvocationType.PRODUCER) < 0) continue;
            this.producerFilters.add(meta.name());
        }
    }

    public List<Filter> createFilters(List<Object> chain) {
        return chain.stream().map(filterConfig -> {
            Filter filter = this.createFilter(filterConfig);
            filter.init(this.engine);
            return filter;
        }).collect(Collectors.toList());
    }

    private Filter createFilter(Object filterConfig) {
        if (filterConfig instanceof String) {
            return this.createFilterByName((String)filterConfig);
        }
        if (filterConfig instanceof TransportFilterConfig) {
            return this.createTransportFilter((TransportFilterConfig)filterConfig);
        }
        throw new IllegalStateException("not support create filter by " + filterConfig);
    }

    private Filter createTransportFilter(TransportFilterConfig config) {
        TransportFilters transportFilters = new TransportFilters();
        for (Map.Entry<String, List<Object>> entry : config.getFiltersByTransport().entrySet()) {
            List<Filter> filters = this.createFilters(entry.getValue());
            transportFilters.getChainByTransport().put(entry.getKey(), FilterNode.buildChain(filters));
        }
        return transportFilters;
    }

    private Filter createFilterByName(String filterName) {
        Factory factory = this.factoryMap.get(filterName);
        if (factory != null) {
            return factory.create();
        }
        throw new IllegalStateException("filter not exist, name=" + filterName);
    }

    private Factory buildFactory(Class<? extends Filter> filterClass, FilterMeta meta) {
        if (meta.shareable()) {
            Filter filter = this.createFilter(filterClass);
            return () -> filter;
        }
        return () -> this.createFilter(filterClass);
    }

    private Filter createFilter(Class<? extends Filter> filterClass) {
        try {
            Filter filter = filterClass.newInstance();
            this.injectSpringBean(filter);
            filter.init(this.engine);
            return filter;
        }
        catch (Exception e) {
            throw new IllegalStateException("failed to create filter.", e);
        }
    }

    private void injectSpringBean(Filter filter) {
        if (this.engine == null || this.engine.getApplicationContext() == null) {
            LOGGER.error("engine or application context is null, only allowed when UT.");
            return;
        }
        this.engine.getApplicationContext().getAutowireCapableBeanFactory().autowireBean((Object)filter);
    }

    static interface Factory {
        public Filter create();
    }
}

