/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.core;

import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import com.netflix.config.DynamicPropertyFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import javax.ws.rs.core.Response;
import org.apache.servicecomb.config.ConfigUtil;
import org.apache.servicecomb.config.priority.PriorityPropertyManager;
import org.apache.servicecomb.core.BootListener;
import org.apache.servicecomb.core.SCBStatus;
import org.apache.servicecomb.core.bootup.BootUpInformationCollector;
import org.apache.servicecomb.core.definition.ConsumerMicroserviceVersionsMeta;
import org.apache.servicecomb.core.definition.CoreMetaUtils;
import org.apache.servicecomb.core.definition.MicroserviceMeta;
import org.apache.servicecomb.core.definition.MicroserviceVersionsMeta;
import org.apache.servicecomb.core.definition.ServiceRegistryListener;
import org.apache.servicecomb.core.event.InvocationFinishEvent;
import org.apache.servicecomb.core.event.InvocationStartEvent;
import org.apache.servicecomb.core.executor.ExecutorManager;
import org.apache.servicecomb.core.filter.FilterChainsManager;
import org.apache.servicecomb.core.handler.ConsumerHandlerManager;
import org.apache.servicecomb.core.handler.HandlerConfigUtils;
import org.apache.servicecomb.core.handler.ProducerHandlerManager;
import org.apache.servicecomb.core.provider.consumer.ConsumerProviderManager;
import org.apache.servicecomb.core.provider.consumer.MicroserviceReferenceConfig;
import org.apache.servicecomb.core.provider.producer.ProducerProviderManager;
import org.apache.servicecomb.core.transport.TransportManager;
import org.apache.servicecomb.foundation.common.VendorExtensions;
import org.apache.servicecomb.foundation.common.event.EnableExceptionPropagation;
import org.apache.servicecomb.foundation.common.event.EventManager;
import org.apache.servicecomb.foundation.common.utils.SPIServiceUtils;
import org.apache.servicecomb.foundation.vertx.VertxUtils;
import org.apache.servicecomb.foundation.vertx.client.http.HttpClients;
import org.apache.servicecomb.registry.DiscoveryManager;
import org.apache.servicecomb.registry.RegistrationManager;
import org.apache.servicecomb.registry.api.event.MicroserviceInstanceRegisteredEvent;
import org.apache.servicecomb.registry.api.registry.MicroserviceInstanceStatus;
import org.apache.servicecomb.registry.consumer.MicroserviceVersions;
import org.apache.servicecomb.registry.definition.MicroserviceNameParser;
import org.apache.servicecomb.registry.swagger.SwaggerLoader;
import org.apache.servicecomb.swagger.engine.SwaggerEnvironment;
import org.apache.servicecomb.swagger.invocation.exception.InvocationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.util.StringUtils;

public class SCBEngine {
    private static final Logger LOGGER = LoggerFactory.getLogger(SCBEngine.class);
    static final String CFG_KEY_WAIT_UP_TIMEOUT = "servicecomb.boot.waitUp.timeoutInMilliseconds";
    static final long DEFAULT_WAIT_UP_TIMEOUT = 10000L;
    static final String CFG_KEY_TURN_DOWN_STATUS_WAIT_SEC = "servicecomb.boot.turnDown.waitInSeconds";
    static final long DEFAULT_TURN_DOWN_STATUS_WAIT_SEC = 0L;
    private static final Object initializationLock = new Object();
    private static volatile SCBEngine INSTANCE;
    private ApplicationContext applicationContext;
    private FilterChainsManager filterChainsManager;
    private ConsumerHandlerManager consumerHandlerManager = new ConsumerHandlerManager();
    private ProducerHandlerManager producerHandlerManager = new ProducerHandlerManager();
    private ProducerProviderManager producerProviderManager;
    private ConsumerProviderManager consumerProviderManager = new ConsumerProviderManager();
    private MicroserviceMeta producerMicroserviceMeta;
    private TransportManager transportManager = new TransportManager();
    private List<BootListener> bootListeners = new ArrayList<BootListener>(SPIServiceUtils.getOrLoadSortedService(BootListener.class));
    private final AtomicLong invocationStartedCounter = new AtomicLong();
    private final AtomicLong invocationFinishedCounter = new AtomicLong();
    private volatile SCBStatus status = SCBStatus.DOWN;
    private EventBus eventBus;
    private ExecutorManager executorManager = new ExecutorManager();
    private PriorityPropertyManager priorityPropertyManager = new PriorityPropertyManager();
    protected List<BootUpInformationCollector> bootUpInformationCollectors = SPIServiceUtils.getSortedService(BootUpInformationCollector.class);
    private ServiceRegistryListener serviceRegistryListener;
    private SwaggerEnvironment swaggerEnvironment = new SwaggerEnvironment();
    private VendorExtensions vendorExtensions = new VendorExtensions();
    private Thread shutdownHook;

    protected SCBEngine() {
        this.eventBus = EventManager.getEventBus();
        this.eventBus.register((Object)this);
        INSTANCE = this;
        this.producerProviderManager = new ProducerProviderManager(this);
        this.serviceRegistryListener = new ServiceRegistryListener(this);
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public VendorExtensions getVendorExtensions() {
        return this.vendorExtensions;
    }

    public String getAppId() {
        return RegistrationManager.INSTANCE.getAppId();
    }

    public void setStatus(SCBStatus status) {
        this.status = status;
    }

    public SCBStatus getStatus() {
        return this.status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SCBEngine getInstance() {
        if (null == INSTANCE) {
            Object object = initializationLock;
            synchronized (object) {
                if (null == INSTANCE) {
                    new SCBEngine();
                }
            }
        }
        return INSTANCE;
    }

    public SwaggerLoader getSwaggerLoader() {
        return RegistrationManager.INSTANCE.getSwaggerLoader();
    }

    public FilterChainsManager getFilterChainsManager() {
        return this.filterChainsManager;
    }

    public SCBEngine setFilterChainsManager(FilterChainsManager filterChainsManager) {
        this.filterChainsManager = filterChainsManager;
        return this;
    }

    public boolean isFilterChainEnabled() {
        return this.filterChainsManager.isEnabled();
    }

    public ConsumerHandlerManager getConsumerHandlerManager() {
        return this.consumerHandlerManager;
    }

    public ProducerHandlerManager getProducerHandlerManager() {
        return this.producerHandlerManager;
    }

    public PriorityPropertyManager getPriorityPropertyManager() {
        return this.priorityPropertyManager;
    }

    public EventBus getEventBus() {
        return this.eventBus;
    }

    public ExecutorManager getExecutorManager() {
        return this.executorManager;
    }

    public void setExecutorManager(ExecutorManager executorManager) {
        this.executorManager = executorManager;
    }

    public ProducerProviderManager getProducerProviderManager() {
        return this.producerProviderManager;
    }

    public void setProducerProviderManager(ProducerProviderManager producerProviderManager) {
        this.producerProviderManager = producerProviderManager;
    }

    public ConsumerProviderManager getConsumerProviderManager() {
        return this.consumerProviderManager;
    }

    public SCBEngine setConsumerProviderManager(ConsumerProviderManager consumerProviderManager) {
        this.consumerProviderManager = consumerProviderManager;
        return this;
    }

    public TransportManager getTransportManager() {
        return this.transportManager;
    }

    public SCBEngine setTransportManager(TransportManager transportManager) {
        this.transportManager = transportManager;
        return this;
    }

    public SwaggerEnvironment getSwaggerEnvironment() {
        return this.swaggerEnvironment;
    }

    public Collection<BootListener> getBootListeners() {
        return this.bootListeners;
    }

    public void addBootListeners(Collection<BootListener> bootListeners) {
        this.bootListeners.addAll(bootListeners);
    }

    public SCBEngine addProducerMeta(String schemaId, Object instance) {
        this.getProducerProviderManager().addProducerMeta(schemaId, instance);
        return this;
    }

    protected void triggerEvent(BootListener.EventType eventType) {
        BootListener.BootEvent event = new BootListener.BootEvent();
        event.setScbEngine(this);
        event.setEventType(eventType);
        for (BootListener listener : this.bootListeners) {
            listener.onBootEvent(event);
        }
    }

    protected void safeTriggerEvent(BootListener.EventType eventType) {
        BootListener.BootEvent event = new BootListener.BootEvent();
        event.setScbEngine(this);
        event.setEventType(eventType);
        for (BootListener listener : this.bootListeners) {
            try {
                listener.onBootEvent(event);
                LOGGER.info("BootListener {} succeed to process {}.", (Object)listener.getClass().getName(), (Object)eventType);
            }
            catch (Throwable e) {
                LOGGER.error("BootListener {} failed to process {}.", new Object[]{listener.getClass().getName(), eventType, e});
            }
        }
    }

    private void triggerAfterRegistryEvent() {
        this.eventBus.register((Object)new AfterRegistryEventHanlder(this));
    }

    @AllowConcurrentEvents
    @Subscribe
    public void onInvocationStart(InvocationStartEvent event) {
        this.invocationStartedCounter.incrementAndGet();
    }

    @AllowConcurrentEvents
    @Subscribe
    public void onInvocationFinish(InvocationFinishEvent event) {
        this.invocationFinishedCounter.incrementAndGet();
    }

    public synchronized SCBEngine run() {
        if (SCBStatus.DOWN.equals((Object)this.status)) {
            try {
                this.doRun();
                this.waitStatusUp();
            }
            catch (TimeoutException e) {
                LOGGER.warn("{}", (Object)e.getMessage());
            }
            catch (Throwable e) {
                LOGGER.error("Failed to start ServiceComb due to errors and close", e);
                try {
                    this.destroy();
                }
                catch (Exception exception) {
                    LOGGER.info("destroy has some error.", (Throwable)exception);
                }
                this.status = SCBStatus.FAILED;
                throw new IllegalStateException("ServiceComb init failed.", e);
            }
            finally {
                this.printServiceInfo();
            }
        }
        return this;
    }

    private void printServiceInfo() {
        StringBuilder serviceInfo = new StringBuilder();
        serviceInfo.append("Service information is shown below:\n");
        for (BootUpInformationCollector bootUpInformationCollector : this.bootUpInformationCollectors) {
            String info = bootUpInformationCollector.collect(this);
            if (StringUtils.isEmpty((Object)info)) continue;
            serviceInfo.append(info).append('\n');
        }
        LOGGER.info(serviceInfo.toString());
    }

    private void doRun() throws Exception {
        this.status = SCBStatus.STARTING;
        this.bootListeners.sort(Comparator.comparingInt(BootListener::getOrder));
        this.triggerEvent(BootListener.EventType.BEFORE_HANDLER);
        HandlerConfigUtils.init(this.consumerHandlerManager, this.producerHandlerManager);
        this.triggerEvent(BootListener.EventType.AFTER_HANDLER);
        this.triggerEvent(BootListener.EventType.BEFORE_FILTER);
        this.filterChainsManager.init(this);
        this.triggerEvent(BootListener.EventType.AFTER_FILTER);
        this.createProducerMicroserviceMeta();
        this.triggerEvent(BootListener.EventType.BEFORE_PRODUCER_PROVIDER);
        this.producerProviderManager.init();
        this.triggerEvent(BootListener.EventType.AFTER_PRODUCER_PROVIDER);
        this.triggerEvent(BootListener.EventType.BEFORE_CONSUMER_PROVIDER);
        this.consumerProviderManager.init();
        this.triggerEvent(BootListener.EventType.AFTER_CONSUMER_PROVIDER);
        this.triggerEvent(BootListener.EventType.BEFORE_TRANSPORT);
        this.transportManager.init(this);
        this.triggerEvent(BootListener.EventType.AFTER_TRANSPORT);
        this.triggerEvent(BootListener.EventType.BEFORE_REGISTRY);
        this.triggerAfterRegistryEvent();
        RegistrationManager.INSTANCE.run();
        DiscoveryManager.INSTANCE.run();
        this.shutdownHook = new Thread(this::destroyForShutdownHook);
        Runtime.getRuntime().addShutdownHook(this.shutdownHook);
    }

    private void createProducerMicroserviceMeta() {
        String microserviceName = RegistrationManager.INSTANCE.getMicroservice().getServiceName();
        this.producerMicroserviceMeta = new MicroserviceMeta(this, microserviceName, false);
        this.producerMicroserviceMeta.setHandlerChain((List)this.producerHandlerManager.getOrCreate(microserviceName));
        this.producerMicroserviceMeta.setFilterChain(this.filterChainsManager.createProducerFilterChain(microserviceName));
        this.producerMicroserviceMeta.setMicroserviceVersionsMeta(new MicroserviceVersionsMeta(this, microserviceName));
    }

    public void destroyForShutdownHook() {
        this.shutdownHook = null;
        this.destroy();
    }

    public synchronized void destroy() {
        if (SCBStatus.UP.equals((Object)this.status) || SCBStatus.STARTING.equals((Object)this.status)) {
            LOGGER.info("ServiceComb is closing now...");
            this.doDestroy();
            this.status = SCBStatus.DOWN;
            LOGGER.info("ServiceComb had closed");
        }
    }

    private void doDestroy() {
        if (this.shutdownHook != null) {
            Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
        }
        this.turnDownInstanceStatus();
        this.blockShutDownOperationForConsumerRefresh();
        this.safeTriggerEvent(BootListener.EventType.BEFORE_CLOSE);
        this.status = SCBStatus.STOPPING;
        RegistrationManager.INSTANCE.destroy();
        DiscoveryManager.INSTANCE.destroy();
        this.serviceRegistryListener.destroy();
        try {
            this.validAllInvocationFinished();
        }
        catch (InterruptedException e) {
            LOGGER.error("wait all invocation finished interrupted", (Throwable)e);
        }
        ConfigUtil.destroyConfigCenterConfigurationSource();
        this.priorityPropertyManager.close();
        VertxUtils.blockCloseVertxByName((String)"transport");
        HttpClients.destroy();
        this.safeTriggerEvent(BootListener.EventType.AFTER_CLOSE);
    }

    private void turnDownInstanceStatus() {
        RegistrationManager.INSTANCE.updateMicroserviceInstanceStatus(MicroserviceInstanceStatus.DOWN);
    }

    private void blockShutDownOperationForConsumerRefresh() {
        try {
            long turnDownWaitSeconds = DynamicPropertyFactory.getInstance().getLongProperty(CFG_KEY_TURN_DOWN_STATUS_WAIT_SEC, 0L).get();
            if (turnDownWaitSeconds <= 0L) {
                return;
            }
            Thread.sleep(TimeUnit.SECONDS.toMillis(turnDownWaitSeconds));
        }
        catch (InterruptedException e) {
            LOGGER.warn("failed to block the shutdown procedure", (Throwable)e);
        }
    }

    private void validAllInvocationFinished() throws InterruptedException {
        long start = System.currentTimeMillis();
        long remaining;
        while ((remaining = this.invocationStartedCounter.get() - this.invocationFinishedCounter.get()) != 0L) {
            if (System.currentTimeMillis() - start > TimeUnit.SECONDS.toMillis(30L)) {
                LOGGER.error("wait for all requests timeout, abandon waiting, remaining requests: {}.", (Object)remaining);
                return;
            }
            TimeUnit.SECONDS.sleep(1L);
        }
        return;
    }

    public void ensureStatusUp() {
        SCBStatus currentStatus = this.getStatus();
        if (!SCBStatus.UP.equals((Object)currentStatus)) {
            String message = "The request is rejected. Cannot process the request due to STATUS = " + (Object)((Object)currentStatus);
            LOGGER.warn(message);
            throw new InvocationException((Response.StatusType)Response.Status.SERVICE_UNAVAILABLE, message);
        }
    }

    public MicroserviceReferenceConfig createMicroserviceReferenceConfig(String microserviceName) {
        return this.createMicroserviceReferenceConfig(microserviceName, null);
    }

    public CompletableFuture<MicroserviceReferenceConfig> createMicroserviceReferenceConfigAsync(String microserviceName, String versionRule) {
        return DiscoveryManager.INSTANCE.getOrCreateMicroserviceVersionsAsync(this.parseAppId(microserviceName), microserviceName).thenApply(versions -> {
            ConsumerMicroserviceVersionsMeta microserviceVersionsMeta = (ConsumerMicroserviceVersionsMeta)CoreMetaUtils.getMicroserviceVersionsMeta(versions);
            return new MicroserviceReferenceConfig(microserviceVersionsMeta, versionRule);
        });
    }

    public MicroserviceReferenceConfig createMicroserviceReferenceConfig(String microserviceName, String versionRule) {
        MicroserviceVersions microserviceVersions = DiscoveryManager.INSTANCE.getOrCreateMicroserviceVersions(this.parseAppId(microserviceName), microserviceName);
        ConsumerMicroserviceVersionsMeta microserviceVersionsMeta = (ConsumerMicroserviceVersionsMeta)CoreMetaUtils.getMicroserviceVersionsMeta(microserviceVersions);
        return new MicroserviceReferenceConfig(microserviceVersionsMeta, versionRule);
    }

    public MicroserviceMeta getProducerMicroserviceMeta() {
        return this.producerMicroserviceMeta;
    }

    public void setProducerMicroserviceMeta(MicroserviceMeta producerMicroserviceMeta) {
        this.producerMicroserviceMeta = producerMicroserviceMeta;
    }

    public void waitStatusUp() throws InterruptedException, TimeoutException {
        long msWait = DynamicPropertyFactory.getInstance().getLongProperty(CFG_KEY_WAIT_UP_TIMEOUT, 10000L).get();
        this.waitStatusUp(msWait);
    }

    public void waitStatusUp(long msWait) throws InterruptedException, TimeoutException {
        SCBStatus currentStatus;
        if (msWait <= 0L) {
            LOGGER.info("Give up waiting for status up, wait timeout milliseconds={}.", (Object)msWait);
            return;
        }
        LOGGER.info("Waiting for status up. timeout: {}ms", (Object)msWait);
        long start = System.currentTimeMillis();
        do {
            currentStatus = this.getStatus();
            switch (currentStatus) {
                case DOWN: 
                case FAILED: {
                    throw new IllegalStateException("Failed to wait status up, real status: " + (Object)((Object)currentStatus));
                }
                case UP: {
                    LOGGER.info("Status already changed to up.");
                    return;
                }
            }
            TimeUnit.MILLISECONDS.sleep(100L);
        } while (System.currentTimeMillis() - start <= msWait);
        throw new TimeoutException(String.format("Timeout to wait status up, timeout: %dms, last status: %s", new Object[]{msWait, currentStatus}));
    }

    public String parseAppId(String microserviceName) {
        return this.parseMicroserviceName(microserviceName).getAppId();
    }

    public MicroserviceNameParser parseMicroserviceName(String microserviceName) {
        return new MicroserviceNameParser(this.getAppId(), microserviceName);
    }

    public static class AfterRegistryEventHanlder {
        private SCBEngine engine;

        public AfterRegistryEventHanlder(SCBEngine engine) {
            this.engine = engine;
        }

        @Subscribe
        @EnableExceptionPropagation
        public void afterRegistryInstance(MicroserviceInstanceRegisteredEvent event) {
            if (event.isRegistrationManager()) {
                LOGGER.info("instance registry succeeds for the first time, will send AFTER_REGISTRY event.");
                this.engine.setStatus(SCBStatus.UP);
                this.engine.triggerEvent(BootListener.EventType.AFTER_REGISTRY);
                EventManager.unregister((Object)this);
                LOGGER.warn("ServiceComb is ready.");
            }
        }
    }
}

