/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.huaweicloud.servicestage;

import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.lang3.StringUtils;
import org.apache.servicecomb.config.ConfigUtil;
import org.apache.servicecomb.foundation.auth.AuthHeaderProvider;
import org.apache.servicecomb.foundation.auth.Cipher;
import org.apache.servicecomb.foundation.auth.DefaultCipher;
import org.apache.servicecomb.foundation.common.utils.BeanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AKSKAuthHeaderProvider
implements AuthHeaderProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(AKSKAuthHeaderProvider.class);
    private static final String CONFIG_AKSK_ENABLED = "servicecomb.credentials.akskEnabled";
    private static final String CONFIG_ACCESS_KEY = "servicecomb.credentials.accessKey";
    private static final String CONFIG_SECRET_KEY = "servicecomb.credentials.secretKey";
    private static final String CONFIG_CIPHER = "servicecomb.credentials.akskCustomCipher";
    private static final String CONFIG_PROJECT = "servicecomb.credentials.project";
    private static final String VALUE_DEFAULT_PROJECT = "default";
    private static final String VALUE_DEFAULT_CIPHER = "default";
    private static final String X_SERVICE_AK = "X-Service-AK";
    private static final String X_SERVICE_SHAAKSK = "X-Service-ShaAKSK";
    private static final String X_SERVICE_PROJECT = "X-Service-Project";
    private Map<String, String> headers = new HashMap<String, String>();
    private Configuration configuration = ConfigUtil.createLocalConfig();
    private boolean enabled = this.configuration.getBoolean("servicecomb.credentials.akskEnabled", true);
    private boolean loaded = false;

    public Map<String, String> authHeaders() {
        if (!this.enabled) {
            return this.headers;
        }
        if (StringUtils.isEmpty((CharSequence)this.getAccessKey())) {
            LOGGER.warn("ak sk auth enabled but access key is not configured, disable it at runtime. Config [{}] to false to disable it implicitly.", (Object)CONFIG_AKSK_ENABLED);
            this.enabled = false;
            return this.headers;
        }
        if (!this.loaded) {
            this.load();
        }
        return this.headers;
    }

    private synchronized void load() {
        if (!this.loaded) {
            this.headers.put(X_SERVICE_AK, this.getAccessKey());
            this.headers.put(X_SERVICE_SHAAKSK, this.getSecretKey());
            this.headers.put(X_SERVICE_PROJECT, this.getProject());
        }
    }

    private String getAccessKey() {
        return this.configuration.getString(CONFIG_ACCESS_KEY, "");
    }

    private String getCipher() {
        return this.configuration.getString(CONFIG_CIPHER, "default");
    }

    private String getSecretKey() {
        String secretKey = this.configuration.getString(CONFIG_SECRET_KEY, "");
        String decodedSecretKey = new String(this.findCipher().decrypt(secretKey.toCharArray()));
        if ("ShaAKSKCipher".equalsIgnoreCase(this.getCipher())) {
            return decodedSecretKey;
        }
        return AKSKAuthHeaderProvider.sha256Encode(decodedSecretKey, this.getAccessKey());
    }

    private String getProject() {
        return this.configuration.getString(CONFIG_PROJECT, "default");
    }

    private Cipher findCipher() {
        if ("default".equals(this.getCipher())) {
            return DefaultCipher.getInstance();
        }
        Map cipherBeans = BeanUtils.getBeansOfType(Cipher.class);
        return cipherBeans.values().stream().filter(c -> c.name().equals(this.getCipher())).findFirst().orElseThrow(() -> new IllegalArgumentException("failed to find cipher named " + this.getCipher()));
    }

    public static String sha256Encode(String key, String data) {
        try {
            Mac sha256HMAC = Mac.getInstance("HmacSHA256");
            SecretKeySpec secretKey = new SecretKeySpec(key.getBytes(StandardCharsets.UTF_8), "HmacSHA256");
            sha256HMAC.init(secretKey);
            return Hex.encodeHexString((byte[])sha256HMAC.doFinal(data.getBytes(StandardCharsets.UTF_8)));
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Can not encode ak sk. Please check the value is correct.", e);
        }
    }
}

