/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.provider.springmvc.reference.async;

import io.netty.handler.codec.http.QueryStringDecoder;
import java.io.OutputStream;
import java.net.URI;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.apache.servicecomb.core.Invocation;
import org.apache.servicecomb.core.provider.consumer.InvokerUtils;
import org.apache.servicecomb.provider.springmvc.reference.CseClientHttpRequest;
import org.apache.servicecomb.provider.springmvc.reference.CseClientHttpResponse;
import org.springframework.http.HttpMethod;
import org.springframework.http.client.AsyncClientHttpRequest;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.util.concurrent.CompletableToListenableFutureAdapter;
import org.springframework.util.concurrent.ListenableFuture;

public class CseAsyncClientHttpRequest
extends CseClientHttpRequest
implements AsyncClientHttpRequest {
    CseAsyncClientHttpRequest() {
    }

    protected CseAsyncClientHttpRequest(URI uri, HttpMethod method) {
        this.setUri(uri);
        this.setMethod(method);
    }

    @Override
    public OutputStream getBody() {
        return null;
    }

    private ListenableFuture<ClientHttpResponse> invoke(Map<String, Object> swaggerArguments) {
        Invocation invocation = this.prepareInvocation(swaggerArguments);
        invocation.getHandlerContext().put("servicecomb-rest-consumer-header", this.getHeaders());
        CompletableFuture<ClientHttpResponse> clientHttpResponseCompletableFuture = this.doAsyncInvoke(invocation);
        return new CompletableToListenableFutureAdapter(clientHttpResponseCompletableFuture);
    }

    protected CompletableFuture<ClientHttpResponse> doAsyncInvoke(Invocation invocation) {
        CompletableFuture<ClientHttpResponse> completableFuture = new CompletableFuture<ClientHttpResponse>();
        InvokerUtils.reactiveInvoke((Invocation)invocation, response -> {
            if (response.isSuccessed()) {
                completableFuture.complete(new CseClientHttpResponse(response));
            } else {
                completableFuture.completeExceptionally((Throwable)response.getResult());
            }
        });
        return completableFuture;
    }

    public ListenableFuture<ClientHttpResponse> executeAsync() {
        this.setPath(this.findUriPath(this.getURI()));
        this.setRequestMeta(this.createRequestMeta(this.getMethod().name(), this.getURI()));
        QueryStringDecoder queryStringDecoder = new QueryStringDecoder(this.getURI().getRawSchemeSpecificPart());
        this.setQueryParams(queryStringDecoder.parameters());
        Map<String, Object> swaggerArguments = this.collectArguments();
        return this.invoke(swaggerArguments);
    }
}

